/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl;

import dev.worldgen.wikiful.api.registry.WikifulRegistries;
import dev.worldgen.wikiful.impl.WikifulClient;
import dev.worldgen.wikiful.impl.duck.TipToastDuck;
import dev.worldgen.wikiful.impl.network.DisplayTipS2C;
import dev.worldgen.wikiful.impl.wiki.tip.Tip;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;

@Mod(value="wikiful", dist={Dist.CLIENT})
public class WikifulClientEntrypoint {
    public WikifulClientEntrypoint(IEventBus bus) {
        WikifulClient.init();
        bus.addListener(WikifulClientEntrypoint::registerPacketHandler);
    }

    private static void registerPacketHandler(RegisterClientPayloadHandlersEvent event) {
        event.register(DisplayTipS2C.TYPE, (packet, context) -> {
            Optional tips = context.player().registryAccess().lookup(WikifulRegistries.TIP);
            if (tips.isEmpty()) {
                return;
            }
            Optional tip = ((Registry)tips.get()).get(packet.id());
            if (tip.isEmpty()) {
                return;
            }
            ((TipToastDuck)Minecraft.getInstance().getToastManager()).addTip((Tip)((Holder.Reference)tip.get()).value());
        });
    }
}

