/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapCodec;
import dev.worldgen.wikiful.api.event.EventTriggerType;
import dev.worldgen.wikiful.api.registry.WikifulRegistries;
import dev.worldgen.wikiful.api.wiki.WikiPage;
import dev.worldgen.wikiful.impl.Wikiful;
import dev.worldgen.wikiful.impl.WikifulEvents;
import dev.worldgen.wikiful.impl.attachment.Attachments;
import dev.worldgen.wikiful.impl.command.WikifulCommand;
import dev.worldgen.wikiful.impl.network.DisplayTipS2C;
import dev.worldgen.wikiful.impl.wiki.body.Body;
import dev.worldgen.wikiful.impl.wiki.category.WikiCategory;
import dev.worldgen.wikiful.impl.wiki.page.section.WikiSection;
import dev.worldgen.wikiful.impl.wiki.tip.Tip;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="wikiful")
public class WikifulEntrypoint {
    public static final DeferredRegister<EventTriggerType<?>> DEFERRED_TRIGGER_TYPES = DeferredRegister.create(WikifulRegistries.EVENT_TRIGGER_TYPE, (String)"wikiful");
    public static final DeferredRegister<MapCodec<? extends Body>> DEFERRED_BODY_TYPES = DeferredRegister.create(WikifulRegistries.BODY_TYPE, (String)"wikiful");
    public static final DeferredRegister<MapCodec<? extends WikiPage>> DEFERRED_WIKI_PAGE_TYPES = DeferredRegister.create(WikifulRegistries.WIKI_PAGE_TYPE, (String)"wikiful");
    public static final Map<String, EventTriggerType<?>> TRIGGER_TYPES = new HashMap();
    public static final Map<String, MapCodec<? extends Body>> BODY_TYPES = new HashMap<String, MapCodec<? extends Body>>();
    public static final Map<String, MapCodec<? extends WikiPage>> WIKI_PAGE_TYPES = new HashMap<String, MapCodec<? extends WikiPage>>();
    public static final Map<String, AttachmentType<?>> ATTACHMENT_TYPES = new HashMap();

    public WikifulEntrypoint(IEventBus bus) {
        Wikiful.init();
        Attachments.init();
        bus.addListener(this::registerDatapackRegistries);
        this.registerAllTheThings(bus);
        bus.addListener(this::registerAttachments);
        bus.addListener(this::registerPayloadTypes);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::onServerStarting);
    }

    private void registerAllTheThings(IEventBus bus) {
        TRIGGER_TYPES.forEach((name, type) -> DEFERRED_TRIGGER_TYPES.register(name, () -> type));
        DEFERRED_TRIGGER_TYPES.register(bus);
        BODY_TYPES.forEach((name, codec) -> DEFERRED_BODY_TYPES.register(name, () -> codec));
        DEFERRED_BODY_TYPES.register(bus);
        WIKI_PAGE_TYPES.forEach((name, codec) -> DEFERRED_WIKI_PAGE_TYPES.register(name, () -> codec));
        DEFERRED_WIKI_PAGE_TYPES.register(bus);
    }

    public void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(WikifulRegistries.TIP, Tip.CODEC, Tip.CODEC);
        event.dataPackRegistry(WikifulRegistries.PAGE, WikiPage.CODEC, WikiPage.CODEC);
        event.dataPackRegistry(WikifulRegistries.SECTION, WikiSection.STANDALONE_CODEC, WikiSection.STANDALONE_CODEC);
        event.dataPackRegistry(WikifulRegistries.CATEGORY, WikiCategory.CODEC, WikiCategory.CODEC);
    }

    public void registerAttachments(RegisterEvent event) {
        event.register(NeoForgeRegistries.Keys.ATTACHMENT_TYPES, helper -> ATTACHMENT_TYPES.forEach((name, type) -> helper.register(Wikiful.id(name), type)));
    }

    public void registerPayloadTypes(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(DisplayTipS2C.TYPE, DisplayTipS2C.CODEC);
    }

    public void registerCommands(RegisterCommandsEvent event) {
        WikifulCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public void onServerStarting(ServerStartingEvent event) {
        WikifulEvents.onRegistryLoad((RegistryAccess)event.getServer().registryAccess());
    }
}

