/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.client;

import dev.worldgen.wikiful.api.client.BodyElement;
import dev.worldgen.wikiful.api.client.BodyElementRegistry;
import dev.worldgen.wikiful.impl.wiki.body.Body;
import dev.worldgen.wikiful.impl.wiki.tip.Tip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;

public class TipToast
implements Toast {
    public static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot");
    private final Tip tip;
    private final int contentWidth;
    private final float displayTime;
    private List<BodyElement> elements = null;
    private int height = 1;
    private Toast.Visibility wantedVisibility = Toast.Visibility.HIDE;

    public TipToast(Tip tip) {
        this.tip = tip;
        this.contentWidth = tip.width() - 2 * tip.padding();
        this.displayTime = 10000.0f * tip.displayTimeMultiplier();
    }

    public int width() {
        return this.tip.width();
    }

    public int height() {
        return this.height;
    }

    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    public void update(ToastManager toastManager, long l) {
        this.wantedVisibility = (double)l >= (double)this.displayTime * toastManager.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public void render(GuiGraphics guiGraphics, Font font, long fullyVisibleFor) {
        if (this.elements == null) {
            this.elements = new ArrayList<BodyElement>();
            for (Body body : this.tip.body()) {
                this.elements.add(BodyElementRegistry.createElement(body));
            }
        }
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.tip.sprite(), 0, 0, this.width(), this.height());
        int y = this.tip.padding();
        for (BodyElement element : this.elements) {
            element.render(guiGraphics, Minecraft.getInstance(), this.tip.padding(), y, this.contentWidth);
            y += element.getHeight(Minecraft.getInstance(), this.contentWidth) + 2;
        }
        if (this.height == 1) {
            this.height = y + this.tip.padding() - 2;
        }
    }
}

