/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.client.body;

import dev.worldgen.wikiful.api.client.BodyElement;
import dev.worldgen.wikiful.impl.wiki.body.Body;
import dev.worldgen.wikiful.impl.wiki.body.HorizontalLineBody;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public record HorizontalLineBodyElement(HorizontalLineBody body) implements BodyElement
{
    public static HorizontalLineBodyElement create(Body body) {
        if (body instanceof HorizontalLineBody) {
            HorizontalLineBody line = (HorizontalLineBody)body;
            return new HorizontalLineBodyElement(line);
        }
        throw new IllegalArgumentException("[Wikiful] Tried to create horizontal line body element with non-horizontal line body");
    }

    @Override
    public int getHeight(Minecraft minecraft, int width) {
        return this.body.spacing() * 2 + this.body().height();
    }

    @Override
    public void render(GuiGraphics graphics, Minecraft minecraft, int x, int y, int width) {
        graphics.fill(x, y += this.body.spacing(), x + width, y + this.body.height() - 1, this.body.color().rgba());
    }
}

