/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.client.body;

import dev.worldgen.wikiful.api.client.BodyElement;
import dev.worldgen.wikiful.impl.client.TipToast;
import dev.worldgen.wikiful.impl.wiki.body.Body;
import dev.worldgen.wikiful.impl.wiki.body.ItemBody;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public record ItemBodyElement(ItemBody body) implements BodyElement
{
    public static ItemBodyElement create(Body body) {
        if (body instanceof ItemBody) {
            ItemBody item = (ItemBody)body;
            return new ItemBodyElement(item);
        }
        throw new IllegalArgumentException("[Wikiful] Tried to create item body element with non-item body");
    }

    @Override
    public int getHeight(Minecraft minecraft, int width) {
        return 18;
    }

    @Override
    public void render(GuiGraphics graphics, Minecraft minecraft, int x, int y, int width) {
        LocalPlayer player;
        ItemStack item = this.body.item().get((int)(Util.getMillis() / 1000L % (long)this.body.item().size()));
        x += this.body.centered() ? width / 2 - 8 : 0;
        if (this.body.showSlot()) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, TipToast.SLOT_SPRITE, x - 1, y - 1, 18, 18);
        }
        if ((player = Minecraft.getInstance().player) == null) {
            graphics.renderFakeItem(item, x, y, 0);
        } else {
            graphics.renderItem((LivingEntity)player, item, x, y, 0);
        }
        if (this.body.showDecorations()) {
            graphics.renderItemDecorations(minecraft.font, item, x, y);
        }
    }
}

