/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.client.screen;

import dev.worldgen.wikiful.api.wiki.WikiPage;
import dev.worldgen.wikiful.impl.client.screen.WikiSelectScreen;
import dev.worldgen.wikiful.impl.client.screen.element.BodyWidget;
import dev.worldgen.wikiful.impl.client.screen.element.PageHeaderWidget;
import dev.worldgen.wikiful.impl.client.screen.element.PageScrollableLayout;
import dev.worldgen.wikiful.impl.client.screen.element.SectionHeaderWidget;
import dev.worldgen.wikiful.impl.wiki.body.EmptyBody;
import dev.worldgen.wikiful.impl.wiki.page.section.WikiSection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;

public class WikiPageScreen
extends Screen {
    private final WikiSelectScreen parent;
    private final WikiPage page;
    private final List<Holder.Reference<WikiSection>> sections;
    protected HeaderAndFooterLayout layout;
    private PageScrollableLayout contents;

    public WikiPageScreen(WikiSelectScreen parent, WikiPage page, List<Holder.Reference<WikiSection>> sections) {
        super(page.commonData().title());
        this.parent = parent;
        this.page = page;
        this.sections = sections;
    }

    protected void init() {
        if (this.layout != null) {
            this.layout.visitWidgets(x$0 -> this.removeWidget((GuiEventListener)x$0));
        }
        this.layout = new HeaderAndFooterLayout((Screen)this);
        this.layout.addToHeader((LayoutElement)new PageHeaderWidget(this.minecraft, this.page, this.width));
        this.setupPages();
        this.layout.addToContents((LayoutElement)this.contents);
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(200).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layout.arrangeElements();
    }

    private void setupPages() {
        LinearLayout layout = LinearLayout.vertical().spacing(2);
        layout.defaultCellSetting().alignHorizontallyLeft().alignVerticallyTop();
        int widgetWidth = this.width - 28;
        layout.addChild((LayoutElement)BodyWidget.create(this.minecraft, new EmptyBody(4), widgetWidth));
        this.page.commonData().opener().forEach(entry -> layout.addChild((LayoutElement)BodyWidget.create(this.minecraft, entry, widgetWidth)));
        for (WikiSection wikiSection : this.page.builtInSections()) {
            this.addSection(layout, widgetWidth, wikiSection, Optional.empty());
        }
        for (WikiSection wikiSection : this.page.commonData().sections()) {
            this.addSection(layout, widgetWidth, wikiSection, Optional.empty());
        }
        for (Holder.Reference reference : this.sections) {
            this.addSection(layout, widgetWidth, (WikiSection)reference.value(), reference.unwrapKey());
        }
        this.contents = new PageScrollableLayout(this.minecraft, (Layout)layout, this.layout.getContentHeight());
        this.contents.setMinWidth(this.width - 12);
        this.contents.setMaxHeight(this.layout.getContentHeight());
    }

    private void addSection(LinearLayout layout, int widgetWidth, WikiSection section, Optional<ResourceKey<WikiSection>> key) {
        SectionHeaderWidget header = new SectionHeaderWidget(this.minecraft, section, key, widgetWidth);
        if (header.getVisibility() == WikiSection.Visibility.INVISIBLE) {
            return;
        }
        layout.addChild((LayoutElement)header);
        if (header.getVisibility() != WikiSection.Visibility.VISIBLE) {
            return;
        }
        section.body().forEach(entry -> layout.addChild((LayoutElement)BodyWidget.create(this.minecraft, entry, widgetWidth)));
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)this.parent);
        this.parent.setInitialFocus();
    }

    public void render(GuiGraphics guiGraphics, int f, int g, float tickDelta) {
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.page.commonData().sprites().background(), 4, 31, this.width - 8, this.height - 62);
        super.render(guiGraphics, f, g, tickDelta);
    }
}

