/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.client.screen;

import dev.worldgen.wikiful.api.registry.WikifulRegistries;
import dev.worldgen.wikiful.api.wiki.CommonWikiData;
import dev.worldgen.wikiful.api.wiki.WikiPage;
import dev.worldgen.wikiful.impl.Wikiful;
import dev.worldgen.wikiful.impl.client.screen.WikiPageScreen;
import dev.worldgen.wikiful.impl.event.UnlockedPages;
import dev.worldgen.wikiful.impl.wiki.category.WikiCategory;
import dev.worldgen.wikiful.impl.wiki.page.section.WikiSection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ScrollableLayout;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class WikiSelectScreen
extends Screen {
    public static final Component TITLE = Component.translatable((String)"menu.wiki.title");
    private static final ResourceLocation INWORLD_MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/inworld_menu_list_background.png");
    private static final ResourceKey<WikiPage> INLINED_PAGE = ResourceKey.create(WikifulRegistries.PAGE, (ResourceLocation)Wikiful.id("inlined"));
    private final Screen parent;
    private final RegistryAccess registries;
    protected HeaderAndFooterLayout layout;
    protected EditBox searchBox;
    private ScrollableLayout pageButtons;
    private final List<Holder<WikiPage>> pages;
    private final List<Holder.Reference<WikiCategory>> categories;
    private final List<Holder.Reference<WikiSection>> sections;

    public WikiSelectScreen(Component title, Minecraft minecraft, Screen parent, List<Holder<WikiPage>> pages, List<Holder.Reference<WikiCategory>> categories) {
        super(title);
        this.registries = minecraft.level.registryAccess();
        this.parent = parent;
        this.pages = pages;
        this.categories = categories;
        this.sections = Wikiful.getReferences(this.registries, WikifulRegistries.SECTION);
    }

    protected void init() {
        if (this.layout != null) {
            this.layout.visitWidgets(x$0 -> this.removeWidget((GuiEventListener)x$0));
        }
        this.layout = new HeaderAndFooterLayout((Screen)this);
        this.layout.addTitleHeader(this.title, this.font);
        if (this.searchBox == null) {
            this.searchBox = new EditBox(this.font, this.width / 2 - 100, 25, 200, 20, this.searchBox, (Component)Component.translatable((String)"selectWorld.search"));
            this.searchBox.setResponder(string -> this.init());
            this.addWidget((GuiEventListener)this.searchBox);
        }
        this.setupPages(this.searchBox.getValue().toLowerCase());
        this.layout.addToContents((LayoutElement)this.pageButtons);
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(200).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layout.arrangeElements();
    }

    private void setupPages(String search) {
        LinearLayout linearLayout = LinearLayout.vertical().spacing(3);
        linearLayout.defaultCellSetting().alignHorizontallyCenter();
        LocalPlayer player = this.minecraft.player;
        for (Holder.Reference<WikiCategory> reference : this.categories) {
            WikiCategory category = (WikiCategory)reference.value();
            if (!category.visible(player, search)) continue;
            linearLayout.addChild((LayoutElement)this.button(category.externalTitle(), new WikiSelectScreen(category.title(), this.minecraft, this, category.pages().stream().toList(), List.of())));
        }
        for (Holder holder : this.pages) {
            CommonWikiData data = ((WikiPage)holder.value()).commonData();
            if (data.trigger().isPresent() && !UnlockedPages.INSTANCE.hasUnlocked((Player)player, WikiSelectScreen.getId((Holder<WikiPage>)holder))) continue;
            String title = data.title().getString();
            if (!search.isEmpty() && !title.toLowerCase().contains(search)) continue;
            linearLayout.addChild((LayoutElement)this.button(data.title(), new WikiPageScreen(this, (WikiPage)holder.value(), this.collectSections((Holder<WikiPage>)holder))));
        }
        this.pageButtons = new ScrollableLayout(this.minecraft, (Layout)linearLayout, this.layout.getContentHeight());
        this.pageButtons.setMaxHeight(this.layout.getContentHeight() - 19);
    }

    public static ResourceLocation getId(Holder<WikiPage> page) {
        return page.unwrapKey().orElse(INLINED_PAGE).location();
    }

    private Button button(Component title, Screen screen) {
        return Button.builder((Component)title, button -> this.minecraft.setScreen(screen)).width(200).build();
    }

    private List<Holder.Reference<WikiSection>> collectSections(Holder<WikiPage> page) {
        return this.sections.stream().filter(section -> ((WikiSection)section.value()).parent().map(holder -> holder.is(page)).orElse(false)).toList();
    }

    public void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.searchBox);
    }

    protected void repositionElements() {
        this.init();
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Screen.INWORLD_HEADER_SEPARATOR, 0, 50, 0.0f, 0.0f, this.width, 2, 32, 2);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Screen.INWORLD_FOOTER_SEPARATOR, 0, this.height - 33, 0.0f, 0.0f, this.width, 2, 32, 2);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, INWORLD_MENU_LIST_BACKGROUND, 0, 51, 0.0f, 0.0f, this.width, this.height - 84, 32, 32);
        super.render(guiGraphics, i, j, f);
        this.searchBox.render(guiGraphics, i, j, f);
    }
}

