/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.client.screen.element;

import dev.worldgen.wikiful.impl.Wikiful;
import dev.worldgen.wikiful.impl.event.UnlockedSections;
import dev.worldgen.wikiful.impl.wiki.page.section.WikiSection;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SectionHeaderWidget
extends AbstractWidget {
    public static final Component UNKNOWN_TITLE = Component.translatable((String)"wikiful.unknown").withStyle(ChatFormatting.GRAY);
    public static final ResourceLocation LOCKED_SPRITE = Wikiful.id("page/lock");
    private static final float SCALE = 1.5f;
    private final Minecraft minecraft;
    private final Component title;
    private final WikiSection.Visibility visibility;
    private final int color;

    public SectionHeaderWidget(Minecraft minecraft, WikiSection section, Optional<ResourceKey<WikiSection>> key, int width) {
        super(0, 0, width, 25, section.title());
        this.minecraft = minecraft;
        this.visibility = this.getVisibility(section, key, minecraft);
        Component baseTitle = section.title();
        switch (this.visibility) {
            case LOCKED_CONTENTS: {
                this.title = baseTitle.copy().withStyle(ChatFormatting.GRAY);
                this.color = -6250336;
                this.setTooltip(Tooltip.create((Component)Component.translatable((String)"wikiful.section_locked")));
                break;
            }
            case LOCKED_ALL: {
                this.title = UNKNOWN_TITLE;
                this.color = -6250336;
                this.setTooltip(Tooltip.create((Component)Component.translatable((String)"wikiful.section_locked")));
                break;
            }
            default: {
                this.title = baseTitle;
                this.color = -1;
            }
        }
    }

    private WikiSection.Visibility getVisibility(WikiSection holder, Optional<ResourceKey<WikiSection>> key, Minecraft minecraft) {
        WikiSection.Visibility sectionVisibility = holder.visibility();
        if (sectionVisibility.equals((Object)WikiSection.Visibility.VISIBLE)) {
            return WikiSection.Visibility.VISIBLE;
        }
        if (minecraft.player == null) {
            return sectionVisibility;
        }
        boolean unlocked = key.map(t -> UnlockedSections.INSTANCE.hasUnlocked((Player)minecraft.player, t.location())).orElse(true);
        return unlocked ? WikiSection.Visibility.VISIBLE : sectionVisibility;
    }

    public WikiSection.Visibility getVisibility() {
        return this.visibility;
    }

    protected void renderWidget(GuiGraphics graphics, int i, int i1, float v) {
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)this.getX(), (float)(this.getY() + 6));
        graphics.pose().scale(1.5f, 1.5f);
        int textX = 0;
        if (this.visibility != WikiSection.Visibility.VISIBLE) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, LOCKED_SPRITE, 0, 0, 8, 8);
            textX = 12;
        }
        graphics.drawWordWrap(this.minecraft.font, (FormattedText)this.title, textX, 0, this.width, -1);
        graphics.pose().popMatrix();
        int lineY = this.getY() + this.getHeight() - 6;
        graphics.fill(this.getX(), lineY, this.getX() + this.width, lineY + 2, this.color);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

