/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.worldgen.wikiful.api.registry.WikifulRegistries;
import dev.worldgen.wikiful.impl.event.UnlockedInfo;
import dev.worldgen.wikiful.impl.event.UnlockedPages;
import dev.worldgen.wikiful.impl.event.UnlockedSections;
import dev.worldgen.wikiful.impl.event.UnlockedTips;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class WikifulCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wikiful").requires((Predicate)Commands.hasPermission((int)2))).then(WikifulCommand.createSubcommand(buildContext, "page", WikifulRegistries.PAGE, UnlockedPages.INSTANCE))).then(WikifulCommand.createSubcommand(buildContext, "section", WikifulRegistries.SECTION, UnlockedSections.INSTANCE))).then(WikifulCommand.createSubcommand(buildContext, "tip", WikifulRegistries.TIP, UnlockedTips.INSTANCE)));
    }

    private static <T> LiteralArgumentBuilder<CommandSourceStack> createSubcommand(CommandBuildContext buildContext, String name, ResourceKey<Registry<T>> key, UnlockedInfo info) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)name).requires((Predicate)Commands.hasPermission((int)2))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(((LiteralArgumentBuilder)Commands.literal((String)"unlock").then(Commands.argument((String)"id", (ArgumentType)ResourceArgument.resource((CommandBuildContext)buildContext, key)).executes(context -> WikifulCommand.unlock((CommandSourceStack)context.getSource(), name, info, EntityArgument.getPlayer((CommandContext)context, (String)"target"), key, Optional.of(ResourceArgument.getResource((CommandContext)context, (String)"id", (ResourceKey)key)))))).then(Commands.literal((String)"*").executes(context -> WikifulCommand.unlock((CommandSourceStack)context.getSource(), name, info, EntityArgument.getPlayer((CommandContext)context, (String)"target"), key, Optional.empty()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"lock").then(Commands.argument((String)"id", (ArgumentType)ResourceArgument.resource((CommandBuildContext)buildContext, key)).executes(context -> WikifulCommand.lock((CommandSourceStack)context.getSource(), name, info, EntityArgument.getPlayer((CommandContext)context, (String)"target"), Optional.of(ResourceArgument.getResource((CommandContext)context, (String)"id", (ResourceKey)key)))))).then(Commands.literal((String)"*").executes(context -> WikifulCommand.lock((CommandSourceStack)context.getSource(), name, info, EntityArgument.getPlayer((CommandContext)context, (String)"target"), Optional.empty())))));
    }

    private static <T> int unlock(CommandSourceStack source, String name, UnlockedInfo info, ServerPlayer player, ResourceKey<Registry<T>> key, Optional<Holder.Reference<T>> entry) {
        if (entry.isEmpty()) {
            source.registryAccess().lookupOrThrow(key).listElements().forEach(holder -> info.add(player, holder.key().location()));
            source.sendSuccess(() -> Component.translatable((String)("command.wikiful.unlocked_all." + name)), false);
            return 1;
        }
        ResourceLocation id = entry.get().key().location();
        if (info.hasUnlocked((Player)player, id)) {
            source.sendFailure((Component)Component.translatable((String)("command.wikiful.already_unlocked." + name), (Object[])new Object[]{id.toString()}));
            return 0;
        }
        info.add(player, id);
        source.sendSuccess(() -> Component.translatable((String)("command.wikiful.unlocked_single." + name), (Object[])new Object[]{id.toString()}), false);
        return 1;
    }

    private static <T> int lock(CommandSourceStack source, String name, UnlockedInfo info, ServerPlayer player, Optional<Holder.Reference<T>> entry) {
        if (entry.isEmpty()) {
            info.clear(player);
            source.sendSuccess(() -> Component.translatable((String)("command.wikiful.locked_all." + name)), false);
            return 1;
        }
        ResourceLocation id = entry.get().key().location();
        if (!info.hasUnlocked((Player)player, id)) {
            source.sendFailure((Component)Component.translatable((String)("command.wikiful.already_locked." + name), (Object[])new Object[]{id.toString()}));
            return 0;
        }
        info.remove(player, id);
        source.sendSuccess(() -> Component.translatable((String)("command.wikiful.locked_single." + name), (Object[])new Object[]{id.toString()}), false);
        return 1;
    }
}

