/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.event.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.wikiful.api.event.EventTrigger;
import dev.worldgen.wikiful.api.event.EventTriggerType;
import dev.worldgen.wikiful.impl.registry.WikifulEventTriggerTypes;
import dev.worldgen.wikiful.impl.registry.WikifulLootParamSets;
import java.util.Optional;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public record HitBlock(Optional<LootItemCondition> condition, Optional<HolderSet<Block>> blocks, Optional<StatePropertiesPredicate> properties) implements EventTrigger
{
    public static final MapCodec<HitBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EventTrigger.conditionCodec(WikifulLootParamSets.HIT_BLOCK).forGetter(HitBlock::condition), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("blocks").forGetter(HitBlock::blocks), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("properties").forGetter(HitBlock::properties)).apply((Applicative)instance, HitBlock::new));

    public static void trigger(ServerLevel level, ServerPlayer player, ItemStack stack, Vec3 vec3, BlockState state) {
        LootContext context = HitBlock.context(level, (Entity)player, stack, vec3, state);
        WikifulEventTriggerTypes.HIT_BLOCK.onListeners(player, trigger -> {
            HitBlock hitBlock;
            return trigger instanceof HitBlock && (hitBlock = (HitBlock)trigger).matches(context, state);
        });
    }

    private boolean matches(LootContext context, BlockState state) {
        if (!this.blocks.map(arg_0 -> ((BlockState)state).is(arg_0)).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.properties.map(predicate -> predicate.matches(state)).orElse(true).booleanValue()) {
            return false;
        }
        return this.condition.map(predicate -> predicate.test((Object)context)).orElse(true);
    }

    private static LootContext context(ServerLevel serverLevel, Entity entity, ItemStack stack, Vec3 vec3, BlockState state) {
        LootParams params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)vec3).withParameter(LootContextParams.TOOL, (Object)stack).withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(WikifulLootParamSets.HIT_BLOCK);
        return new LootContext.Builder(params).create(Optional.empty());
    }

    @Override
    public EventTriggerType<? extends EventTrigger> type() {
        return WikifulEventTriggerTypes.HIT_BLOCK;
    }
}

