/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.event.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.wikiful.api.event.EventTrigger;
import dev.worldgen.wikiful.api.event.EventTriggerType;
import dev.worldgen.wikiful.impl.registry.WikifulEventTriggerTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public record InventoryChanged(Optional<LootItemCondition> condition, Slots slots, List<ItemPredicate> items) implements EventTrigger
{
    public static final MapCodec<InventoryChanged> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EventTrigger.conditionCodec(LootContextParamSets.ADVANCEMENT_ENTITY).forGetter(InventoryChanged::condition), (App)Slots.CODEC.optionalFieldOf("slots", (Object)Slots.ANY).forGetter(InventoryChanged::slots), (App)ItemPredicate.CODEC.listOf().optionalFieldOf("items", List.of()).forGetter(InventoryChanged::items)).apply((Applicative)instance, InventoryChanged::new));

    public static void trigger(ServerPlayer player, Inventory inventory, ItemStack changedStack) {
        LootContext context = EntityPredicate.createContext((ServerPlayer)player, (Entity)player);
        WikifulEventTriggerTypes.INVENTORY_CHANGED.onListeners(player, trigger -> {
            InventoryChanged inventoryChanged;
            return trigger instanceof InventoryChanged && (inventoryChanged = (InventoryChanged)trigger).matches(context, player, inventory, changedStack);
        });
    }

    public boolean matches(Inventory inventory, ItemStack changedStack) {
        int full = 0;
        int empty = 0;
        int occupied = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack itemStack2 = inventory.getItem(i);
            if (itemStack2.isEmpty()) {
                ++empty;
                continue;
            }
            ++occupied;
            if (itemStack2.getCount() < itemStack2.getMaxStackSize()) continue;
            ++full;
        }
        if (!this.slots.matches(full, empty, occupied)) {
            return false;
        }
        if (this.items.isEmpty()) {
            return true;
        }
        if (this.items.size() != 1) {
            ObjectArrayList predicates = new ObjectArrayList(this.items);
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                if (predicates.isEmpty()) {
                    return true;
                }
                ItemStack stack = inventory.getItem(i);
                if (stack.isEmpty()) continue;
                predicates.removeIf(predicate -> predicate.test(stack));
            }
            return predicates.isEmpty();
        }
        return !changedStack.isEmpty() && this.items.getFirst().test(changedStack);
    }

    private boolean matches(LootContext context, ServerPlayer player, Inventory inventory, ItemStack changedStack) {
        if (!this.matches(inventory, changedStack)) {
            return false;
        }
        return this.condition.map(predicate -> predicate.test((Object)context)).orElse(true);
    }

    @Override
    public EventTriggerType<? extends EventTrigger> type() {
        return WikifulEventTriggerTypes.INVENTORY_CHANGED;
    }

    public record Slots(MinMaxBounds.Ints occupied, MinMaxBounds.Ints full, MinMaxBounds.Ints empty) {
        public static final Codec<Slots> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MinMaxBounds.Ints.CODEC.optionalFieldOf("occupied", (Object)MinMaxBounds.Ints.ANY).forGetter(Slots::occupied), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("full", (Object)MinMaxBounds.Ints.ANY).forGetter(Slots::full), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("empty", (Object)MinMaxBounds.Ints.ANY).forGetter(Slots::empty)).apply((Applicative)instance, Slots::new));
        public static final Slots ANY = new Slots(MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY);

        public boolean matches(int full, int empty, int occupied) {
            if (!this.full.matches(full)) {
                return false;
            }
            if (!this.empty.matches(empty)) {
                return false;
            }
            return this.occupied.matches(occupied);
        }
    }
}

