/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.event.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.wikiful.api.event.EventTrigger;
import dev.worldgen.wikiful.api.event.EventTriggerType;
import dev.worldgen.wikiful.impl.registry.WikifulEventTriggerTypes;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public record LocationChanged(Optional<LootItemCondition> condition, LocationPredicate location) implements EventTrigger
{
    public static final MapCodec<LocationChanged> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EventTrigger.conditionCodec(LootContextParamSets.ADVANCEMENT_ENTITY).forGetter(LocationChanged::condition), (App)LocationPredicate.CODEC.fieldOf("location").forGetter(LocationChanged::location)).apply((Applicative)instance, LocationChanged::new));

    public static void trigger(ServerLevel level, ServerPlayer player) {
        LootContext context = EntityPredicate.createContext((ServerPlayer)player, (Entity)player);
        WikifulEventTriggerTypes.LOCATION_CHANGED.onListeners(player, trigger -> {
            LocationChanged locationChanged;
            return trigger instanceof LocationChanged && (locationChanged = (LocationChanged)trigger).matches(context, level, player);
        });
    }

    private boolean matches(LootContext context, ServerLevel level, ServerPlayer player) {
        if (!this.location.matches(level, player.getX(), player.getY(), player.getZ())) {
            return false;
        }
        return this.condition.map(predicate -> predicate.test((Object)context)).orElse(true);
    }

    @Override
    public EventTriggerType<? extends EventTrigger> type() {
        return WikifulEventTriggerTypes.LOCATION_CHANGED;
    }
}

