/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.wiki.category;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.wikiful.api.registry.WikifulRegistries;
import dev.worldgen.wikiful.api.wiki.WikiPage;
import dev.worldgen.wikiful.impl.client.screen.WikiSelectScreen;
import dev.worldgen.wikiful.impl.event.UnlockedPages;
import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.entity.player.Player;

public record WikiCategory(Component title, Component externalTitle, HolderSet<WikiPage> pages, HolderSet<WikiCategory> categories, boolean showIfEmpty) {
    public static final Codec<WikiCategory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("title").forGetter(WikiCategory::title), (App)ComponentSerialization.CODEC.optionalFieldOf("external_title").forGetter(category -> Optional.of(category.externalTitle)), (App)RegistryCodecs.homogeneousList(WikifulRegistries.PAGE).fieldOf("pages").orElse((Object)HolderSet.empty()).forGetter(WikiCategory::pages), (App)RegistryCodecs.homogeneousList(WikifulRegistries.CATEGORY).fieldOf("categories").orElse((Object)HolderSet.empty()).forGetter(WikiCategory::categories), (App)Codec.BOOL.fieldOf("show_if_empty").forGetter(WikiCategory::showIfEmpty)).apply((Applicative)instance, WikiCategory::new));

    public WikiCategory(Component title, Optional<Component> externalTitle, HolderSet<WikiPage> pages, HolderSet<WikiCategory> categories, boolean showIfEmpty) {
        this(title, externalTitle.orElse(title), pages, categories, showIfEmpty);
    }

    public boolean visible(LocalPlayer player, String search) {
        if (this.showIfEmpty) {
            return true;
        }
        for (Holder page : this.pages) {
            if (!UnlockedPages.INSTANCE.hasUnlocked((Player)player, WikiSelectScreen.getId((Holder<WikiPage>)page)) || !WikiCategory.matchesSearch(((WikiPage)page.value()).commonData().title(), search)) continue;
            return true;
        }
        for (Holder category : this.categories) {
            if (!((WikiCategory)category.value()).visible(player, search) || !WikiCategory.matchesSearch(((WikiCategory)category.value()).title(), search)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesSearch(Component title, String search) {
        return search.isEmpty() || title.getString().toLowerCase().contains(search);
    }
}

