/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.wiki.tip;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.wikiful.api.event.EventTrigger;
import dev.worldgen.wikiful.impl.Wikiful;
import dev.worldgen.wikiful.impl.event.TriggerHolder;
import dev.worldgen.wikiful.impl.event.UnlockedTips;
import dev.worldgen.wikiful.impl.network.DisplayTipS2C;
import dev.worldgen.wikiful.impl.wiki.body.Body;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.network.PacketDistributor;

public record Tip(EventTrigger trigger, ResourceLocation sprite, int width, int padding, float displayTimeMultiplier, List<Body> body) implements TriggerHolder
{
    private static final ResourceLocation DEFAULT_SPRITE = Wikiful.id("tip/default");
    public static final Codec<Tip> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EventTrigger.CODEC.fieldOf("trigger").forGetter(Tip::trigger), (App)ResourceLocation.CODEC.fieldOf("sprite").orElse((Object)DEFAULT_SPRITE).forGetter(Tip::sprite), (App)ExtraCodecs.POSITIVE_INT.fieldOf("width").orElse((Object)240).forGetter(Tip::width), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("padding").orElse((Object)12).forGetter(Tip::padding), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("display_time_multiplier").orElse((Object)Float.valueOf(1.0f)).forGetter(Tip::displayTimeMultiplier), (App)Body.LIST_CODEC.fieldOf("body").forGetter(Tip::body)).apply((Applicative)instance, Tip::new));

    @Override
    public Optional<EventTrigger> getTrigger() {
        return Optional.of(this.trigger);
    }

    @Override
    public void onTriggered(ServerPlayer player, ResourceLocation id) {
        UnlockedTips.INSTANCE.add(player, id);
        this.sendToast(player, id);
    }

    public void sendToast(ServerPlayer player, ResourceLocation id) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DisplayTipS2C(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

