/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.mixin.client;

import com.google.common.collect.Queues;
import dev.worldgen.wikiful.impl.client.TipToast;
import dev.worldgen.wikiful.impl.duck.TipToastDuck;
import dev.worldgen.wikiful.impl.wiki.tip.Tip;
import java.util.Deque;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ToastManager.class})
public abstract class ToastManagerMixin
implements TipToastDuck {
    @Shadow
    @Final
    Minecraft minecraft;
    @Shadow
    @Final
    private Set<SoundEvent> playedToastSounds;
    @Unique
    private final Deque<TipToast> queuedTips = Queues.newArrayDeque();
    @Unique
    @Nullable
    private ToastManager.ToastInstance<TipToast> visibleTip;

    @Inject(method={"update"}, at={@At(value="TAIL")})
    private void updateTips(CallbackInfo ci) {
        ToastManager $this = (ToastManager)this;
        if (this.visibleTip != null) {
            Toast.Visibility visibility = this.visibleTip.visibility;
            this.visibleTip.update();
            if (this.visibleTip.visibility != visibility) {
                this.visibleTip.visibility.playSound(this.minecraft.getSoundManager());
            }
            if (this.visibleTip.hasFinishedRendering()) {
                this.visibleTip = null;
            }
        }
        if (!this.queuedTips.isEmpty() && (this.visibleTip == null || this.visibleTip.hasFinishedRendering())) {
            TipToast tipToast = this.queuedTips.removeFirst();
            ToastManager toastManager = $this;
            Objects.requireNonNull(toastManager);
            this.visibleTip = new ToastManager.ToastInstance(toastManager, (Toast)tipToast, 0, 0);
            SoundEvent soundEvent = tipToast.getSoundEvent();
            if (soundEvent != null && this.playedToastSounds.add(soundEvent)) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)soundEvent, (float)1.0f, (float)1.0f));
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderTips(GuiGraphics guiGraphics, CallbackInfo ci) {
        if (!this.minecraft.options.hideGui && this.visibleTip != null) {
            this.visibleTip.render(guiGraphics, guiGraphics.guiWidth());
        }
    }

    @Inject(method={"clear"}, at={@At(value="TAIL")})
    private void clearTips(CallbackInfo ci) {
        this.visibleTip = null;
    }

    @Override
    public void addTip(Tip tip) {
        this.queuedTips.add(new TipToast(tip));
    }

    @Override
    public float getTipYOffset(Toast toast) {
        if (this.visibleTip == null || toast instanceof TipToast) {
            return 0.0f;
        }
        return ((TipToast)this.visibleTip.getToast()).height();
    }
}

