/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.event.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.wikiful.api.event.EventTrigger;
import dev.worldgen.wikiful.api.event.EventTriggerType;
import dev.worldgen.wikiful.impl.registry.WikifulEventTriggerTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_5341;

public record InventoryChanged(Optional<class_5341> condition, Slots slots, List<class_2073> items) implements EventTrigger
{
    public static final MapCodec<InventoryChanged> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EventTrigger.conditionCodec(class_173.field_24423).forGetter(InventoryChanged::condition), (App)Slots.CODEC.optionalFieldOf("slots", (Object)Slots.ANY).forGetter(InventoryChanged::slots), (App)class_2073.field_45754.listOf().optionalFieldOf("items", List.of()).forGetter(InventoryChanged::items)).apply((Applicative)instance, InventoryChanged::new));

    public static void trigger(class_3222 player, class_1661 inventory, class_1799 changedStack) {
        class_47 context = class_2048.method_27802((class_3222)player, (class_1297)player);
        WikifulEventTriggerTypes.INVENTORY_CHANGED.onListeners(player, trigger -> {
            InventoryChanged inventoryChanged;
            return trigger instanceof InventoryChanged && (inventoryChanged = (InventoryChanged)trigger).matches(context, player, inventory, changedStack);
        });
    }

    public boolean matches(class_1661 inventory, class_1799 changedStack) {
        int full = 0;
        int empty = 0;
        int occupied = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack2 = inventory.method_5438(i);
            if (itemStack2.method_7960()) {
                ++empty;
                continue;
            }
            ++occupied;
            if (itemStack2.method_7947() < itemStack2.method_7914()) continue;
            ++full;
        }
        if (!this.slots.matches(full, empty, occupied)) {
            return false;
        }
        if (this.items.isEmpty()) {
            return true;
        }
        if (this.items.size() != 1) {
            ObjectArrayList predicates = new ObjectArrayList(this.items);
            for (int i = 0; i < inventory.method_5439(); ++i) {
                if (predicates.isEmpty()) {
                    return true;
                }
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960()) continue;
                predicates.removeIf(predicate -> predicate.method_8970(stack));
            }
            return predicates.isEmpty();
        }
        return !changedStack.method_7960() && this.items.getFirst().method_8970(changedStack);
    }

    private boolean matches(class_47 context, class_3222 player, class_1661 inventory, class_1799 changedStack) {
        if (!this.matches(inventory, changedStack)) {
            return false;
        }
        return this.condition.map(predicate -> predicate.test((Object)context)).orElse(true);
    }

    @Override
    public EventTriggerType<? extends EventTrigger> type() {
        return WikifulEventTriggerTypes.INVENTORY_CHANGED;
    }

    public record Slots(class_2096.class_2100 occupied, class_2096.class_2100 full, class_2096.class_2100 empty) {
        public static final Codec<Slots> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2096.class_2100.field_45763.optionalFieldOf("occupied", (Object)class_2096.class_2100.field_9708).forGetter(Slots::occupied), (App)class_2096.class_2100.field_45763.optionalFieldOf("full", (Object)class_2096.class_2100.field_9708).forGetter(Slots::full), (App)class_2096.class_2100.field_45763.optionalFieldOf("empty", (Object)class_2096.class_2100.field_9708).forGetter(Slots::empty)).apply((Applicative)instance, Slots::new));
        public static final Slots ANY = new Slots(class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708);

        public boolean matches(int full, int empty, int occupied) {
            if (!this.full.method_9054(full)) {
                return false;
            }
            if (!this.empty.method_9054(empty)) {
                return false;
            }
            return this.occupied.method_9054(occupied);
        }
    }
}

