/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.wiki.category;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.wikiful.api.registry.WikifulRegistries;
import dev.worldgen.wikiful.api.wiki.WikiPage;
import dev.worldgen.wikiful.impl.client.screen.WikiSelectScreen;
import dev.worldgen.wikiful.impl.event.UnlockedPages;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_746;
import net.minecraft.class_8824;

public record WikiCategory(class_2561 title, class_2561 externalTitle, class_6885<WikiPage> pages, class_6885<WikiCategory> categories, boolean showIfEmpty) {
    public static final Codec<WikiCategory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_8824.field_46597.fieldOf("title").forGetter(WikiCategory::title), (App)class_8824.field_46597.optionalFieldOf("external_title").forGetter(category -> Optional.of(category.externalTitle)), (App)class_6895.method_40340(WikifulRegistries.PAGE).fieldOf("pages").orElse((Object)class_6885.method_58563()).forGetter(WikiCategory::pages), (App)class_6895.method_40340(WikifulRegistries.CATEGORY).fieldOf("categories").orElse((Object)class_6885.method_58563()).forGetter(WikiCategory::categories), (App)Codec.BOOL.fieldOf("show_if_empty").forGetter(WikiCategory::showIfEmpty)).apply((Applicative)instance, WikiCategory::new));

    public WikiCategory(class_2561 title, Optional<class_2561> externalTitle, class_6885<WikiPage> pages, class_6885<WikiCategory> categories, boolean showIfEmpty) {
        this(title, externalTitle.orElse(title), pages, categories, showIfEmpty);
    }

    public boolean visible(class_746 player, String search) {
        if (this.showIfEmpty) {
            return true;
        }
        for (class_6880 page : this.pages) {
            if (!UnlockedPages.INSTANCE.hasUnlocked((class_1657)player, WikiSelectScreen.getId((class_6880<WikiPage>)page)) || !WikiCategory.matchesSearch(((WikiPage)page.comp_349()).commonData().title(), search)) continue;
            return true;
        }
        for (class_6880 category : this.categories) {
            if (!((WikiCategory)category.comp_349()).visible(player, search) || !WikiCategory.matchesSearch(((WikiCategory)category.comp_349()).title(), search)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesSearch(class_2561 title, String search) {
        return search.isEmpty() || title.getString().toLowerCase().contains(search);
    }
}

