/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl.wiki.page.section;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.wikiful.api.event.EventTrigger;
import dev.worldgen.wikiful.api.registry.WikifulRegistries;
import dev.worldgen.wikiful.api.wiki.WikiPage;
import dev.worldgen.wikiful.impl.event.TriggerHolder;
import dev.worldgen.wikiful.impl.event.UnlockedSections;
import dev.worldgen.wikiful.impl.wiki.body.Body;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_8824;

public record WikiSection(Optional<class_6880<WikiPage>> parent, Optional<EventTrigger> trigger, Visibility visibility, class_2561 title, List<Body> body) implements TriggerHolder
{
    private static final Codec<WikiSection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6899.method_40400(WikifulRegistries.PAGE).optionalFieldOf("parent").forGetter(WikiSection::parent), (App)EventTrigger.CODEC.optionalFieldOf("trigger").forGetter(WikiSection::trigger), (App)Visibility.CODEC.fieldOf("visibility").orElse((Object)Visibility.VISIBLE).forGetter(WikiSection::visibility), (App)class_8824.field_46597.fieldOf("title").forGetter(WikiSection::title), (App)Body.FULL_CODEC.listOf().fieldOf("body").forGetter(WikiSection::body)).apply((Applicative)instance, WikiSection::new)).validate(WikiSection::validate);
    public static final Codec<WikiSection> STANDALONE_CODEC = CODEC.validate(WikiSection::validateStandalone);
    public static final Codec<WikiSection> PAGE_CODEC = CODEC.validate(WikiSection::validatePage);

    private static DataResult<WikiSection> validate(WikiSection section) {
        boolean hasTrigger;
        boolean visible = section.visibility == Visibility.VISIBLE;
        if (visible == (hasTrigger = section.trigger.isPresent())) {
            if (visible) {
                return DataResult.error(() -> "Wiki section with trigger should be locked or invisible");
            }
            return DataResult.error(() -> "Wiki section locked or invisible should have a trigger");
        }
        return DataResult.success((Object)section);
    }

    private static DataResult<WikiSection> validatePage(WikiSection section) {
        if (section.parent().isPresent()) {
            return DataResult.error(() -> "Wiki section inside of page should not have parent");
        }
        if (section.visibility != Visibility.VISIBLE) {
            return DataResult.error(() -> "Wiki section inside of page should always be visible");
        }
        return DataResult.success((Object)section);
    }

    private static DataResult<WikiSection> validateStandalone(WikiSection section) {
        if (section.parent().isEmpty()) {
            return DataResult.error(() -> "Standalone wiki section should have parent");
        }
        return DataResult.success((Object)section);
    }

    @Override
    public Optional<EventTrigger> getTrigger() {
        return this.trigger;
    }

    @Override
    public void onTriggered(class_3222 player, class_2960 id) {
        UnlockedSections.INSTANCE.add(player, id);
    }

    public static enum Visibility implements class_3542
    {
        VISIBLE("visible"),
        LOCKED_CONTENTS("locked_contents"),
        LOCKED_ALL("locked_all"),
        INVISIBLE("invisible");

        public static final Codec<Visibility> CODEC;
        private final String name;

        private Visibility(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Visibility::values);
        }
    }
}

