/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.mixin.client;

import com.google.common.collect.Queues;
import dev.worldgen.wikiful.impl.client.TipToast;
import dev.worldgen.wikiful.impl.duck.TipToastDuck;
import dev.worldgen.wikiful.impl.wiki.tip.Tip;
import java.util.Deque;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_368;
import net.minecraft.class_374;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_374.class})
public abstract class ToastManagerMixin
implements TipToastDuck {
    @Shadow
    @Final
    class_310 field_2238;
    @Shadow
    @Final
    private Set<class_3414> field_55860;
    @Unique
    private final Deque<TipToast> queuedTips = Queues.newArrayDeque();
    @Unique
    @Nullable
    private class_374.class_375<TipToast> visibleTip;

    @Inject(method={"method_61990()V"}, at={@At(value="TAIL")})
    private void updateTips(CallbackInfo ci) {
        class_374 $this = (class_374)this;
        if (this.visibleTip != null) {
            class_368.class_369 visibility = this.visibleTip.field_2244;
            this.visibleTip.method_61995();
            if (this.visibleTip.field_2244 != visibility) {
                this.visibleTip.field_2244.method_1988(this.field_2238.method_1483());
            }
            if (this.visibleTip.method_61994()) {
                this.visibleTip = null;
            }
        }
        if (!this.queuedTips.isEmpty() && (this.visibleTip == null || this.visibleTip.method_61994())) {
            TipToast tipToast = this.queuedTips.removeFirst();
            class_374 class_3742 = $this;
            Objects.requireNonNull(class_3742);
            this.visibleTip = new class_374.class_375(class_3742, (class_368)tipToast, 0, 0);
            class_3414 soundEvent = tipToast.method_66530();
            if (soundEvent != null && this.field_55860.add(soundEvent)) {
                this.field_2238.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)soundEvent, (float)1.0f, (float)1.0f));
            }
        }
    }

    @Inject(method={"method_1996(Lnet/minecraft/class_332;)V"}, at={@At(value="TAIL")})
    private void renderTips(class_332 guiGraphics, CallbackInfo ci) {
        if (!this.field_2238.field_1690.field_1842 && this.visibleTip != null) {
            this.visibleTip.method_2002(guiGraphics, guiGraphics.method_51421());
        }
    }

    @Inject(method={"method_2000()V"}, at={@At(value="TAIL")})
    private void clearTips(CallbackInfo ci) {
        this.visibleTip = null;
    }

    @Override
    public void addTip(Tip tip) {
        this.queuedTips.add(new TipToast(tip));
    }

    @Override
    public float getTipYOffset(class_368 toast) {
        if (this.visibleTip == null || toast instanceof TipToast) {
            return 0.0f;
        }
        return ((TipToast)this.visibleTip.method_2001()).method_29050();
    }
}

