/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.List;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.components.IComponentGoggleInformation;
import org.patryk3211.powergrid.circuits.components.IRedstoneComponent;
import org.patryk3211.powergrid.circuits.components.IRenderedComponent;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.IntProperty;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedPartialModels;
import org.patryk3211.powergrid.utility.Lang;

public abstract class GaugeComponent
extends OrientableComponent
implements IRedstoneComponent,
IRenderedComponent,
IComponentGoggleInformation {
    public static final IntProperty LEVEL = (IntProperty)new IntProperty("powergrid", "redstone_level", 0, 0, 15).hidden();

    public GaugeComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{LEVEL, LABEL});
    }

    @Override
    public boolean isEmitter() {
        return true;
    }

    @Override
    public int getEmittedLevel(@NotNull PlacedComponent component) {
        return component.get(LEVEL);
    }

    public abstract float getTarget(PlacedComponent var1);

    @Override
    public boolean tick(@NotNull PlacedComponent placed) {
        int redstoneLevel;
        float target = this.getTarget(placed);
        if (GaugeComponent.getEdge(placed) != null && (redstoneLevel = class_3532.method_15340((int)((int)(target * 15.0f)), (int)0, (int)15)) != placed.get(LEVEL)) {
            placed.set(LEVEL, redstoneLevel);
            IRedstoneComponent.notifyNeighbours(placed);
        }
        placed.onClientWorld(() -> level -> {
            RenderData data;
            Object patt0$temp = placed.customData;
            if (patt0$temp instanceof RenderData) {
                RenderData current;
                data = current = (RenderData)patt0$temp;
            } else {
                data = new RenderData();
                placed.customData = data;
            }
            data.prevState = data.state;
            data.state += (target - data.state) * 0.125f;
            if (data.state > 1.0f && level.field_9229.method_43057() < 0.5f) {
                data.state -= (data.state - 1.0f) * level.field_9229.method_43057();
            }
        });
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(CircuitBoardBlockEntity be, PlacedComponent placed, float partialTicks, class_4587 ms, class_4597 bufferSource, int light, int overlay) {
        Object object = placed.customData;
        if (object instanceof RenderData) {
            RenderData data = (RenderData)object;
            float value = class_3532.method_16439((float)partialTicks, (float)data.prevState, (float)data.state);
            SuperByteBuffer buffer = CachedBuffers.partial((PartialModel)ModdedPartialModels.COMPONENT_GAUGE_NEEDLE, (class_2680)be.method_11010());
            float angle = -90.0f * value;
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)buffer.translate(0.15625, 0.0, 0.15625)).rotateYDegrees((float)(((Orientation)((Object)placed.get(ORIENTATION))).ordinal() * 90))).translate(-0.0625f, 0.0f, 0.0625f)).rotateYDegrees(angle)).translate(-0.09375, 0.0, -0.21875)).light(light).renderInto(ms, bufferSource.getBuffer(class_1921.method_23577()));
        }
    }

    @Override
    public boolean addToGoggleTooltip(PlacedComponent component, List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (component.has(LABEL)) {
            String label = component.get(LABEL);
            if (label.isEmpty()) {
                Lang.builder((String)"create").translate("gui.gauge.info_header", new Object[0]).forGoggles(tooltip);
            } else {
                Lang.text(label).forGoggles(tooltip);
            }
        } else {
            Lang.builder((String)"create").translate("gui.gauge.info_header", new Object[0]).forGoggles(tooltip);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class RenderData {
        private float prevState;
        private float state;
    }
}

