/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.EdgeComponent;
import org.patryk3211.powergrid.circuits.components.IRedstoneComponent;
import org.patryk3211.powergrid.circuits.components.properties.BooleanProperty;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class RedstoneRelayComponent
extends EdgeComponent
implements IRedstoneComponent {
    public static final float RESISTANCE = 0.1f;
    public static final BooleanProperty POWERED = (BooleanProperty)new BooleanProperty("powergrid", "redstone_relay_powered").hidden();

    public RedstoneRelayComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{POWERED, RedstoneRelayComponent.current(32.0f)});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder,  @NotNull ThermalBuilder.IEmitter thermals) {
        SwitchedWire wire = builder.connectSwitch(0.1f, builder.terminalNode(0), builder.terminalNode(1), placed.get(POWERED));
        placed.add(wire);
        thermals.builder().setMaxCurrent(32.0f, 0.1f, 125.0f).setThermalMass(0.075f).addHeatSource(wire);
    }

    @Override
    public boolean isReceiver() {
        return true;
    }

    @Override
    public void receiveRedstone(@NotNull PlacedComponent component, int level) {
        component.set(POWERED, level > 0);
        component.notifyClients(POWERED);
        this.stateUpdated(component);
    }

    @Override
    @NotNull
    public class_2960 getModelId(@NotNull PlacedComponent component) {
        class_2960 base = super.getModelId(component);
        if (component.get(POWERED).booleanValue()) {
            return new class_2960(base.method_12836(), base.method_12832() + "_on");
        }
        return base;
    }

    @Override
    @NotNull
    public Collection<class_2960> requestedModels() {
        return List.of(PowerGrid.asResource("redstone_relay"), PowerGrid.asResource("redstone_relay_on"));
    }

    @Override
    public void stateUpdated(@NotNull PlacedComponent placed) {
        placed.onClientWorld(() -> world -> RedstoneRelayComponent.modelChanged(placed.getPos()));
        if (placed.wires.isEmpty()) {
            return;
        }
        SwitchedWire wire = (SwitchedWire)placed.wires.get(0);
        wire.setState(placed.get(POWERED));
    }
}

