/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import net.minecraft.class_2382;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.BooleanProperty;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;

public class RelayComponent
extends OrientableComponent {
    public static final FloatProperty THRESHOLD_VOLTAGE = new FloatProperty("powergrid", "relay_threshold", 12.0f, 1.0f, 48.0f);
    public static final BooleanProperty STATE = (BooleanProperty)new BooleanProperty("powergrid", "relay_state").hidden();

    public RelayComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{THRESHOLD_VOLTAGE, STATE, RelayComponent.current(32.0f)});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder,  @NotNull ThermalBuilder.IEmitter thermals) {
        float resistance = placed.get(THRESHOLD_VOLTAGE).floatValue() / 0.1f;
        ElectricWire coilWire = builder.connect(resistance, builder.terminalNode(0), builder.terminalNode(1));
        float switchResistance = 0.05f;
        FloatingNode common = builder.terminalNode(3);
        Boolean state = placed.get(STATE);
        SwitchedWire normallyClosed = builder.connectSwitch(0.05f, common, builder.terminalNode(2), state == false);
        SwitchedWire normallyOpen = builder.connectSwitch(0.05f, common, builder.terminalNode(4), state);
        placed.add(coilWire);
        placed.add(normallyClosed);
        placed.add(normallyOpen);
        thermals.builder().setMaxCurrent(0.2f, resistance, 125.0f).setThermalMass(0.02f).addHeatSource(coilWire);
        thermals.builder().setMaxCurrent(32.0f, 0.05f, 125.0f).setThermalMass(0.075f).addHeatSource(normallyClosed).addHeatSource(normallyOpen);
    }

    @Override
    public boolean tick(@NotNull PlacedComponent placed) {
        if (placed.wires.isEmpty()) {
            return true;
        }
        AbstractElectricWire coilWire = placed.wires.get(0);
        float current = Math.abs(coilWire.current());
        SwitchedWire NC = (SwitchedWire)placed.wires.get(1);
        SwitchedWire NO = (SwitchedWire)placed.wires.get(2);
        if (placed.get(STATE).booleanValue() && current < 0.1f * ModdedConfigs.server().electricity.holdingCurrentPercent.getF()) {
            NC.setState(true);
            NO.setState(false);
            placed.set(STATE, false);
            placed.onServerWorld(() -> world -> ModdedSoundEvents.RELAY_CLICK.playOnServer(world, (class_2382)placed.getPos(), 0.75f, 1.9f));
        } else if (!placed.get(STATE).booleanValue() && current > 0.1f) {
            NC.setState(false);
            NO.setState(true);
            placed.set(STATE, true);
            placed.onServerWorld(() -> world -> ModdedSoundEvents.RELAY_CLICK.playOnServer(world, (class_2382)placed.getPos(), 0.75f, 2.0f));
        }
        return true;
    }
}

