/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.Component;
import org.patryk3211.powergrid.circuits.components.IGoggleLabel;
import org.patryk3211.powergrid.circuits.components.IInteractableComponent;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.BooleanProperty;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.circuits.thermal.ThermalBuilder;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class SwitchComponent
extends OrientableComponent
implements IInteractableComponent,
IGoggleLabel {
    public static final BooleanProperty STATE = new BooleanProperty("powergrid", "switch_state");

    public SwitchComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{STATE, LABEL, SwitchComponent.current(16.0f)});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder, @NotNull ThermalBuilder.IEmitter thermals) {
        SwitchedWire wire = builder.connectSwitch(0.1f, builder.terminalNode(0), builder.terminalNode(1), placed.get(STATE));
        placed.add(wire);
        thermals.builder().setMaxCurrent(16.0f, 0.1f, 150.0f).setThermalMass(0.01f).addHeatSource(wire);
    }

    @Override
    public class_265 getShape(@NotNull PlacedComponent placed) {
        return IInteractableComponent.extrudedFootprint(placed, 0.125f);
    }

    @Override
    public class_1269 use(CircuitBoardBlockEntity be, PlacedComponent placed, class_1657 player) {
        boolean newState = placed.get(STATE) == false;
        placed.set(STATE, newState);
        if (be.method_10997().field_9236) {
            Component.modelChanged(be.method_11016());
        } else {
            if (newState) {
                ModdedSoundEvents.MICROSWITCH_ON.playOnServer(be.method_10997(), (class_2382)be.method_11016());
            } else {
                ModdedSoundEvents.MICROSWITCH_OFF.playOnServer(be.method_10997(), (class_2382)be.method_11016());
            }
            placed.notifyClients(STATE);
            this.stateUpdated(placed);
        }
        be.method_5431();
        return class_1269.field_5812;
    }

    @Override
    public void stateUpdated(@NotNull PlacedComponent placed) {
        super.stateUpdated(placed);
        if (placed.wires.isEmpty()) {
            return;
        }
        ((SwitchedWire)placed.wires.get(0)).setState(placed.get(STATE));
    }

    @Override
    @NotNull
    public class_2960 getModelId(@NotNull PlacedComponent component) {
        return component.get(STATE) != false ? PowerGrid.asResource("switch_on") : PowerGrid.asResource("switch");
    }

    @Override
    @NotNull
    public Collection<class_2960> requestedModels() {
        return List.of(PowerGrid.asResource("switch"), PowerGrid.asResource("switch_on"));
    }
}

