/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components.properties;

import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.patryk3211.powergrid.circuits.components.properties.CalculatedProperty;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;

public class PropertyEntry<T> {
    public final ComponentProperty<T> property;
    public final PlacedComponent parent;
    protected T value;

    protected PropertyEntry(ComponentProperty<T> property, PlacedComponent parent) {
        this.property = property;
        this.parent = parent;
        this.value = property.defaultValue();
    }

    public static <T> PropertyEntry<T> makeFor(ComponentProperty<T> property, PlacedComponent parent) {
        if (property instanceof CalculatedProperty) {
            CalculatedProperty calculatedProperty = (CalculatedProperty)property;
            return new Calculated(calculatedProperty, parent);
        }
        return new PropertyEntry<T>(property, parent);
    }

    public void read(class_2487 compound) {
        if (this.property instanceof CalculatedProperty) {
            return;
        }
        class_2520 element = compound.method_10580(this.property.id().toString());
        this.value = element == null ? this.property.defaultValue() : this.property.read(element);
    }

    public void write(class_2487 compound) {
        class_2520 element = this.property.write(this.value);
        if (element == null) {
            return;
        }
        compound.method_10566(this.property.id().toString(), element);
    }

    public String stringValue() {
        return this.property.toString(this.value);
    }

    public void setValue(String value) {
        try {
            this.value = this.property.parse(value);
        }
        catch (RuntimeException e) {
            this.value = this.property.defaultValue();
        }
    }

    public void setValueRaw(Object value) {
        this.value = value;
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public static class Calculated<T>
    extends PropertyEntry<T> {
        private final CalculatedProperty<T> calculated;

        protected Calculated(CalculatedProperty<T> property, PlacedComponent parent) {
            super(property, parent);
            this.calculated = property;
        }

        @Override
        public void read(class_2487 compound) {
        }

        @Override
        public void write(class_2487 compound) {
        }

        @Override
        public void setValue(String value) {
            throw new IllegalCallerException("Cannot set value of calculated property");
        }

        @Override
        public void setValueRaw(Object value) {
        }

        @Override
        public void set(T value) {
            throw new IllegalCallerException("Cannot set value of calculated property");
        }

        @Override
        public String stringValue() {
            return this.calculated.toString(this.get());
        }

        @Override
        public T get() {
            return this.calculated.calculate(this.parent);
        }
    }
}

