/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.components.Component;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableBlockEntity;
import org.patryk3211.powergrid.circuits.editor.CircuitEditMenu;
import org.patryk3211.powergrid.circuits.gui.CircuitEditWidget;
import org.patryk3211.powergrid.circuits.gui.ComponentPropertiesWidget;
import org.patryk3211.powergrid.circuits.schematic.CircuitLayer;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematicRender;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.ISchematicHolder;
import org.patryk3211.powergrid.circuits.schematic.Line;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModIcons;
import org.patryk3211.powergrid.collections.ModdedKeys;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.network.packets.ChangeScreenC2SPacket;
import org.patryk3211.powergrid.network.packets.SaveSchematicC2SPacket;
import org.patryk3211.powergrid.utility.Lang;

public class CircuitDesignTableEditScreen<T extends CircuitEditMenu<?>>
extends AbstractSimiContainerScreen<T> {
    private static final class_2960 BACKGROUND = PowerGrid.texture("gui/circuit_design_table_edit");
    private static final int WIDTH = 182;
    private static final int HEIGHT = 160;
    public static final int CIRCUIT_SCALE = 8;
    private static final class_2561 TOOLTIP_SAVE = Lang.translateDirect("gui.circuit_designer.save", new Object[0]);
    private static final class_2561 TOOLTIP_DISCARD = Lang.translateDirect("gui.circuit_designer.discard", new Object[0]);
    private static final class_2561 TOOLTIP_CONNECT = Lang.translateDirect("gui.circuit_designer.connect", new Object[0]);
    private static final class_2561 TOOLTIP_DELETE = Lang.translateDirect("gui.circuit_designer.delete", new Object[0]);
    private static final class_2561 TOOLTIP_SELECT = Lang.translateDirect("gui.circuit_designer.select", new Object[0]);
    private static final class_2561 TOOLTIP_LAYER = Lang.translateDirect("gui.circuit_designer.layer", new Object[0]);
    private static final class_2561 TOOLTIP_PLACEABLE = Lang.translate("gui.circuit_designer.placeable", new Object[0]).style(class_124.field_1077).style(class_124.field_1056).component();
    private static final class_2561 TEXT_SAVING = Lang.translateDirect("gui.circuit_designer.saving", new Object[0]);
    private static final class_2561 TEXT_NOT_SAVED = Lang.translateDirect("gui.circuit_designer.not_saved", new Object[0]);
    private final CircuitSchematic schematic;
    private List<Line> fgLines;
    private List<Line> bgLines;
    private boolean tracesChanged = false;
    private Tool currentTool = Tool.SELECT;
    private PlacedComponent currentComponent = null;
    private class_1735 selectedSlot = null;
    private PlacedComponent selectedComponent = null;
    private CircuitEditWidget editWidget;
    private boolean backLayer = false;
    private class_342 nameField;
    private IconButton acceptBtn;
    private IconButton cancelBtn;
    private IconButton connectBtn;
    private IconButton deleteBtn;
    private IconButton selectBtn;
    private IconButton layerBtn;
    private ComponentPropertiesWidget propertiesWidget;
    private boolean changed = false;
    private boolean saving = false;
    private int unsavedPopupTimeout = 0;

    public CircuitDesignTableEditScreen(T container, class_1661 inv, class_2561 title) {
        super(container, inv, title);
        this.schematic = new CircuitSchematic(((ISchematicHolder)((SmartBlockEntity)((CircuitEditMenu)((Object)container)).contentHolder)).getSchematic());
        this.fgLines = this.schematic.front().calculateLines();
        this.bgLines = this.schematic.back().calculateLines();
    }

    private static class_1144 soundManager() {
        return class_310.method_1551().method_1483();
    }

    private static void playSound(AllSoundEvents.SoundEntry sound) {
        CircuitDesignTableEditScreen.soundManager().method_4873((class_1113)class_1109.method_4758((class_3414)sound.getMainEvent(), (float)1.0f));
    }

    public void save() {
        ModdedPackets.getChannel().sendToServer((Object)new SaveSchematicC2SPacket((SmartBlockEntity)((CircuitEditMenu)this.field_2797).contentHolder, this.nameField.method_1882(), this.schematic));
        Object object = ((CircuitEditMenu)this.field_2797).contentHolder;
        if (object instanceof CircuitDesignTableBlockEntity) {
            CircuitDesignTableBlockEntity table = (CircuitDesignTableBlockEntity)object;
            ((ISchematicHolder)((SmartBlockEntity)((CircuitEditMenu)this.field_2797).contentHolder)).setSchematic(this.schematic);
            this.saving = true;
        } else {
            this.method_25419();
        }
    }

    public void discard() {
        Object object = ((CircuitEditMenu)this.field_2797).contentHolder;
        if (object instanceof CircuitDesignTableBlockEntity) {
            CircuitDesignTableBlockEntity table = (CircuitDesignTableBlockEntity)object;
            ModdedPackets.getChannel().sendToServer((Object)new ChangeScreenC2SPacket(table, 0));
        } else {
            this.method_25419();
        }
    }

    protected void flipLayer() {
        if (this.tracesChanged) {
            if (this.backLayer) {
                this.bgLines = this.schematic.back().calculateLines();
            } else {
                this.fgLines = this.schematic.front().calculateLines();
            }
            this.tracesChanged = false;
        }
        this.backLayer = !this.backLayer;
        this.layerBtn.setIcon((ScreenElement)(this.backLayer ? ModIcons.I_LAYER_BACK : ModIcons.I_LAYER_FRONT));
    }

    protected void method_25426() {
        this.setWindowSize(182, 164 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(11, 0);
        super.method_25426();
        this.editWidget = new CircuitEditWidget(this.field_22793, this.schematic, this.field_2776 + 13 - 11, this.field_2800 + 22, 128, 128);
        this.propertiesWidget = new ComponentPropertiesWidget(this.field_22793, this.field_2776 - 15, this.field_2800 + 12);
        String name = ((ISchematicHolder)((SmartBlockEntity)((CircuitEditMenu)this.field_2797).contentHolder)).getSchematicName();
        this.nameField = new class_342(this.field_22793, this.field_2776 + 4 - 11, this.field_2800 + 3, 148, 9, (class_2561)class_2561.method_43473());
        this.nameField.method_1852(name);
        this.nameField.method_1868(-1);
        this.nameField.method_1860(-1);
        this.nameField.method_1858(false);
        this.nameField.method_1880(35);
        this.nameField.method_1888(true);
        this.selectedComponent = null;
        this.currentComponent = null;
        this.selectedSlot = null;
        int BUTTONS_X = this.field_2776 + 154 - 11;
        this.acceptBtn = new IconButton(BUTTONS_X, this.field_2800 + 43, (ScreenElement)AllIcons.I_CONFIRM);
        this.cancelBtn = new IconButton(BUTTONS_X, this.field_2800 + 63, (ScreenElement)ModIcons.I_CANCEL);
        this.connectBtn = new IconButton(BUTTONS_X, this.field_2800 + 83, (ScreenElement)ModIcons.I_CONNECT);
        this.deleteBtn = new IconButton(BUTTONS_X, this.field_2800 + 101, (ScreenElement)AllIcons.I_TRASH);
        this.selectBtn = new IconButton(BUTTONS_X, this.field_2800 + 119, (ScreenElement)AllIcons.I_TARGET);
        this.layerBtn = new IconButton(BUTTONS_X, this.field_2800 + 139, (ScreenElement)ModIcons.I_LAYER_FRONT);
        this.acceptBtn.setToolTip(TOOLTIP_SAVE);
        this.cancelBtn.setToolTip(TOOLTIP_DISCARD);
        this.connectBtn.setToolTip(TOOLTIP_CONNECT);
        this.deleteBtn.setToolTip(TOOLTIP_DELETE);
        this.selectBtn.setToolTip(TOOLTIP_SELECT);
        this.layerBtn.setToolTip(TOOLTIP_LAYER);
        this.acceptBtn.withCallback(this::save);
        this.cancelBtn.withCallback(this::discard);
        this.connectBtn.withCallback(() -> this.toolSelect(Tool.CONNECT));
        this.deleteBtn.withCallback(() -> this.toolSelect(Tool.DELETE));
        this.selectBtn.withCallback(() -> this.toolSelect(Tool.SELECT));
        this.layerBtn.withCallback(this::flipLayer);
        this.editWidget.setSelectionCancelledCallback(() -> this.toolSelect(Tool.SELECT));
        this.toolSelect(Tool.SELECT);
        this.method_37063((class_364)this.nameField);
        this.method_37063((class_364)this.editWidget);
        this.method_37063((class_364)this.propertiesWidget);
        this.method_37063((class_364)this.acceptBtn);
        this.method_37063((class_364)this.cancelBtn);
        this.method_37063((class_364)this.connectBtn);
        this.method_37063((class_364)this.deleteBtn);
        this.method_37063((class_364)this.selectBtn);
        this.method_37063((class_364)this.layerBtn);
    }

    public class_768 ghostTarget() {
        return new class_768(this.editWidget.method_46426(), this.editWidget.method_46427(), this.editWidget.method_25368(), this.editWidget.method_25364());
    }

    protected List<class_2561> method_51454(class_1799 stack) {
        List lines = super.method_51454(stack);
        if (Component.forItem(stack.method_7909()) != null) {
            lines.add(TOOLTIP_PLACEABLE);
        }
        return lines;
    }

    private void toolSelect(Tool tool) {
        if (this.currentComponent != null) {
            this.currentComponent = null;
            this.selectedSlot = null;
            this.editWidget.stopComponentPlacement();
        }
        if (this.selectedComponent != null) {
            this.propertiesWidget.setComponent(null);
            this.selectedComponent = null;
        }
        this.currentTool = tool;
        switch (tool.ordinal()) {
            case 0: {
                this.editWidget.requestSelection(CircuitEditWidget.SelectMode.LINE, -2130706433, this::placeTrace);
                break;
            }
            case 1: {
                this.editWidget.requestSelection(CircuitEditWidget.SelectMode.AREA, -2130739072, this::deleteArea);
                break;
            }
            case 2: {
                this.editWidget.requestSelection(CircuitEditWidget.SelectMode.POINT, -2130706433, this::selectComponent);
            }
        }
    }

    private void toolSelect(class_1735 slot) {
        Component component = Component.forItem(slot.method_7677().method_7909());
        if (component == null) {
            return;
        }
        this.editWidget.cancelSelection();
        if (this.selectedComponent != null) {
            this.selectedComponent = null;
            this.propertiesWidget.setComponent(null);
        }
        PlacedComponent placed = new PlacedComponent(component, 0, 0, UUID.randomUUID());
        this.editWidget.componentPlacement(placed, this::placeComponent);
        this.currentComponent = placed;
        this.selectedSlot = slot;
    }

    public void toolSelect(class_1792 item) {
        Component component = Component.forItem(item);
        if (component == null) {
            return;
        }
        this.editWidget.cancelSelection();
        if (this.selectedComponent != null) {
            this.selectedComponent = null;
            this.propertiesWidget.setComponent(null);
        }
        PlacedComponent placed = new PlacedComponent(component, 0, 0, UUID.randomUUID());
        this.editWidget.componentPlacement(placed, this::placeComponent);
        this.currentComponent = placed;
        this.selectedSlot = null;
    }

    private CircuitEditWidget.SelectionResult placeTrace(int x1, int y1, int x2, int y2, int clickX, int clickY) {
        CircuitLayer layer = this.backLayer ? this.schematic.back() : this.schematic.front();
        boolean isTrace = layer.get(clickX, clickY);
        layer.fill(x1, y1, x2, y2);
        Line line = x1 == x2 ? new Line(true, x1, y1, y2 + 1) : new Line(false, y1, x1, x2 + 1);
        this.tracesChanged = true;
        if (this.backLayer) {
            this.bgLines.add(line);
        } else {
            this.fgLines.add(line);
        }
        this.changed = true;
        CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_PLACE_TRACE);
        if (this.schematic.isPad(clickX, clickY) || isTrace) {
            return CircuitEditWidget.SelectionResult.BEGIN_NEW;
        }
        return CircuitEditWidget.SelectionResult.CONTINUE;
    }

    public CircuitEditWidget.SelectionResult deleteArea(int x1, int y1, int x2, int y2, int clickX, int clickY) {
        CircuitLayer layer = this.backLayer ? this.schematic.back() : this.schematic.front();
        layer.clear(x1, y1, x2, y2);
        if (this.backLayer) {
            this.bgLines = layer.calculateLines();
        } else {
            this.fgLines = layer.calculateLines();
        }
        CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_DELETE_AREA);
        this.changed = true;
        return CircuitEditWidget.SelectionResult.BEGIN_NEW;
    }

    public CircuitEditWidget.SelectionResult selectComponent(int x1, int y1, int x2, int y2, int clickX, int clickY) {
        PlacedComponent placed = this.schematic.getComponent(x1 / 1, y1 / 1);
        if (placed == null) {
            CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_FAIL);
            return CircuitEditWidget.SelectionResult.IGNORE;
        }
        this.selectedComponent = placed;
        this.propertiesWidget.setComponent(this.selectedComponent);
        CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_SELECT_COMPONENT);
        this.changed = true;
        return CircuitEditWidget.SelectionResult.BEGIN_NEW;
    }

    public void placeComponent(int x, int y) {
        if (this.schematic.canPlace(this.currentComponent, x, y)) {
            CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_PLACE_COMPONENT);
            this.schematic.placeComponent(this.currentComponent, x, y);
            this.changed = true;
        } else {
            CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_FAIL);
        }
    }

    protected void method_2389(class_332 ctx, float delta, int mouseX, int mouseY) {
        int bgX = this.getLeftOfCentered(182);
        int invY = this.field_2800 + 160 + 4;
        this.renderPlayerInventory(ctx, bgX + 182 - AllGuiTextures.PLAYER_INVENTORY.getWidth(), invY);
        for (int k = 0; k < ((CircuitEditMenu)this.field_2797).field_7761.size(); ++k) {
            class_1735 slot = (class_1735)((CircuitEditMenu)this.field_2797).field_7761.get(k);
            if (!slot.method_7682() || !slot.method_7681()) continue;
            if (slot == this.selectedSlot) {
                ctx.method_25302(BACKGROUND, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, 232, 18, 18, 18);
                continue;
            }
            if (Component.forItem(slot.method_7677().method_7909()) == null) continue;
            ctx.method_25302(BACKGROUND, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, 232, 0, 18, 18);
        }
        ctx.method_25302(BACKGROUND, bgX, this.field_2800, 0, 0, 182, 160);
        int bpX = bgX + 13;
        int bpY = this.field_2800 + 22;
        if (!this.backLayer) {
            CircuitSchematicRender.renderLayer(this.bgLines, ctx, bpX, bpY, 8, -2130706433);
            CircuitSchematicRender.renderLayer(this.fgLines, ctx, bpX, bpY, 8, -1);
        } else {
            CircuitSchematicRender.renderLayer(this.fgLines, ctx, bpX, bpY, 8, -2130706433);
            CircuitSchematicRender.renderLayer(this.bgLines, ctx, bpX, bpY, 8, -1);
        }
        CircuitSchematicRender.renderComponents(this.schematic, ctx, bpX, bpY, 8, mouseX, mouseY);
        if (this.currentTool.y > 0) {
            ctx.method_25302(BACKGROUND, this.field_2776 + 173 - 11, this.field_2800 + this.currentTool.y, 250, 0, 6, 18);
        }
        if (this.selectedComponent != null) {
            ComponentFootprint footprint = this.selectedComponent.footprint();
            ctx.method_49601(bpX + this.selectedComponent.x * 8 * 1 - 1, bpY + this.selectedComponent.y * 8 * 1 - 1, footprint.getWidth() * 8 * 1 + 2, footprint.getHeight() * 8 * 1 + 2, -2132035020);
        }
        if (this.unsavedPopupTimeout > 0) {
            int color = 0xFF6060;
            int alpha = Math.min(this.unsavedPopupTimeout, 20) * 255 / 20;
            ctx.method_27534(this.field_22793, TEXT_NOT_SAVED, this.field_22789 / 2, this.field_2800 - 12, color |= alpha << 24);
        }
    }

    protected void method_37432() {
        super.method_37432();
        if (!((CircuitEditMenu)this.field_2797).method_34255().method_7960()) {
            this.toolSelect(((CircuitEditMenu)this.field_2797).method_34255().method_7909());
            ((CircuitEditMenu)this.field_2797).method_34254(class_1799.field_8037);
        }
        if (this.unsavedPopupTimeout > 0) {
            --this.unsavedPopupTimeout;
        }
    }

    protected void method_2380(class_332 context, int mouseX, int mouseY) {
        super.method_2380(context, mouseX, mouseY);
        int x = this.editWidget.method_46426();
        int y = this.editWidget.method_46427();
        int gridX = (mouseX - x) / 8;
        int gridY = (mouseY - y) / 8;
        for (PlacedComponent placed : this.schematic.components()) {
            class_2561 tooltip;
            ComponentFootprint footprint;
            int localX = gridX - placed.x * 1;
            int localY = gridY - placed.y * 1;
            if (localX < 0 || localY < 0 || localX >= (footprint = placed.footprint()).getWidth() * 1 || localY >= footprint.getHeight() * 1 || (tooltip = footprint.getTooltip(localX, localY)) == null) continue;
            context.method_51438(this.field_22793, tooltip, mouseX, mouseY);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean handled;
        if (keyCode == 256) {
            if (!this.changed || this.saving) {
                this.method_25419();
            } else {
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_FAIL);
                this.unsavedPopupTimeout = 60;
            }
            return true;
        }
        class_364 focused = this.method_25399();
        boolean bl = handled = focused != null && focused.method_25404(keyCode, scanCode, modifiers);
        if (handled) {
            return true;
        }
        if (this.selectedComponent != null || focused instanceof class_342) {
            return false;
        }
        class_304[] hotbar = this.field_22787.field_1690.field_1852;
        for (int i = 0; i < hotbar.length; ++i) {
            if (!hotbar[i].method_1417(keyCode, scanCode)) continue;
            this.toolSelect(((CircuitEditMenu)this.field_2797).method_7611(i + 27));
            return true;
        }
        if (ModdedKeys.ROTATE_COMPONENT.matchesKey(keyCode, scanCode)) {
            if (this.currentComponent != null && this.currentComponent.has(Orientation.PROPERTY)) {
                Orientation current = this.currentComponent.get(Orientation.PROPERTY);
                current = class_437.method_25442() ? current.getCounterClockwise() : current.getClockwise();
                this.currentComponent.set(Orientation.PROPERTY, current);
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_COMPONENT_ROTATE);
                return true;
            }
        } else {
            if (ModdedKeys.PLACE_TRACE.matchesKey(keyCode, scanCode)) {
                this.toolSelect(Tool.CONNECT);
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_PLACE_TRACE);
                return true;
            }
            if (ModdedKeys.DELETE_AREA.matchesKey(keyCode, scanCode)) {
                this.toolSelect(Tool.DELETE);
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_DELETE_AREA);
                return true;
            }
            if (ModdedKeys.PICK_COMPONENT.matchesKey(keyCode, scanCode)) {
                this.toolSelect(Tool.SELECT);
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_SELECT_COMPONENT);
                return true;
            }
            if (ModdedKeys.SWITCH_LAYER.matchesKey(keyCode, scanCode)) {
                this.flipLayer();
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_CLICK);
                return true;
            }
        }
        return false;
    }

    public void method_25394(@NotNull class_332 ctx, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(ctx, mouseX, mouseY, partialTicks);
        if (this.saving) {
            RenderSystem.disableDepthTest();
            class_4587 ms = ctx.method_51448();
            ms.method_22903();
            ms.method_46416(0.0f, 0.0f, 10.0f);
            ctx.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
            AllIcons.I_CONFIG_SAVE.render(ctx, this.field_22789 / 2 - 8, this.field_22790 / 2 - 8);
            ctx.method_27534(this.field_22793, TEXT_SAVING, this.field_22789 / 2, this.field_22790 / 2 + 12, -1);
            ms.method_22909();
        }
    }

    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (slot == null || !slot.method_7681() || actionType != class_1713.field_7790) {
            return;
        }
        this.toolSelect(slot);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1) {
            if (this.currentComponent == null && this.currentTool == Tool.SELECT) {
                int gridX = (int)((mouseX - (double)this.editWidget.method_46426()) / 8.0);
                int gridY = (int)((mouseY - (double)this.editWidget.method_46427()) / 8.0);
                if (gridX >= 0 && gridY >= 0 && gridX < 16 && gridY < 16) {
                    this.schematic.removeComponents(gridX, gridY, 1, 1);
                }
            }
            if (this.currentComponent != null) {
                this.currentComponent = null;
                this.selectedSlot = null;
                this.editWidget.stopComponentPlacement();
            }
            if (this.selectedComponent != null) {
                this.selectedComponent = null;
                this.propertiesWidget.setComponent(null);
            }
            this.editWidget.cancelSelection();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private static enum Tool {
        CONNECT(83),
        DELETE(101),
        SELECT(119);

        public final int y;

        private Tool(int y) {
            this.y = y;
        }
    }
}

