/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.gui;

import java.util.function.BiConsumer;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;

public class CircuitEditWidget
extends AbstractSimiWidget {
    private int scale = 8;
    private final class_327 textRenderer;
    private boolean selectStarted = false;
    private int startX;
    private int startY;
    private SelectMode selectMode = SelectMode.NONE;
    private int selectionColor = 0;
    private SelectCallback selectionCallback = null;
    private Runnable selectionCancelledCallback = null;
    private PlacedComponent placedComponent = null;
    private BiConsumer<Integer, Integer> placementCallback;
    private final CircuitSchematic schematic;

    public CircuitEditWidget(class_327 textRenderer, CircuitSchematic schematic, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.textRenderer = textRenderer;
        this.schematic = schematic;
    }

    protected void doRender(@NotNull class_332 ctx, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_22762) {
            return;
        }
        int x = this.method_46426();
        int y = this.method_46427();
        int gridX = (mouseX - x) / this.scale;
        int gridY = (mouseY - y) / this.scale;
        if (gridX >= 16 || gridY >= 16) {
            return;
        }
        class_4587 ms = ctx.method_51448();
        ms.method_46416((float)x, (float)y, 5.0f);
        ms.method_22905((float)this.scale, (float)this.scale, (float)this.scale);
        if (this.placedComponent != null) {
            ComponentFootprint footprint = this.placedComponent.footprint();
            int offsetX = footprint.getWidth() / 2;
            int offsetY = footprint.getHeight() / 2;
            footprint.render(ctx, ((gridX /= 1) - offsetX) * 1, ((gridY /= 1) - offsetY) * 1, true);
            footprint.renderPadIndices(ctx, this.textRenderer, (gridX - offsetX) * 1, (gridY - offsetY) * 1);
            ms.method_22903();
            ms.method_22905(1.0f / (float)this.scale, 1.0f / (float)this.scale, 1.0f / (float)this.scale);
            int color = this.schematic.canPlace(this.placedComponent, gridX - offsetX, gridY - offsetY) ? -2139029632 : -2130739072;
            ctx.method_49601((gridX - offsetX) * this.scale * 1, (gridY - offsetY) * this.scale * 1, footprint.getWidth() * this.scale * 1, footprint.getHeight() * this.scale * 1, color);
            ms.method_22909();
            return;
        }
        if (this.selectMode == SelectMode.NONE || this.selectMode == SelectMode.POINT) {
            ms.method_22903();
            ms.method_22905(1.0f / (float)this.scale, 1.0f / (float)this.scale, 1.0f / (float)this.scale);
            ctx.method_49601(gridX * this.scale, gridY * this.scale, this.scale, this.scale, -5592321);
            ms.method_22909();
        } else if (!this.selectStarted) {
            ctx.method_25294(gridX, gridY, gridX + 1, gridY + 1, this.selectionColor);
        } else if (this.selectMode == SelectMode.LINE) {
            int lenY;
            int lenX = Math.abs(gridX - this.startX) + 1;
            if (lenX >= (lenY = Math.abs(gridY - this.startY) + 1)) {
                int x1 = Math.min(gridX, this.startX);
                int x2 = x1 + lenX;
                ctx.method_25294(x1, this.startY, x2, this.startY + 1, this.selectionColor);
            } else {
                int y1 = Math.min(gridY, this.startY);
                int y2 = y1 + lenY;
                ctx.method_25294(this.startX, y1, this.startX + 1, y2, this.selectionColor);
            }
        } else if (this.selectMode == SelectMode.AREA) {
            int x1 = Math.min(this.startX, gridX);
            int y1 = Math.min(this.startY, gridY);
            int x2 = Math.max(this.startX, gridX) + 1;
            int y2 = Math.max(this.startY, gridY) + 1;
            ctx.method_25294(x1, y1, x2, y2, this.selectionColor);
        }
    }

    private void handleCallback(int endX, int endY) {
        SelectionResult result = SelectionResult.END;
        if (this.selectionCallback != null) {
            int y1;
            int y2;
            int x1;
            int x2;
            switch (this.selectMode.ordinal()) {
                case 1: {
                    x1 = x2 = endX;
                    y1 = y2 = endY;
                    break;
                }
                case 2: {
                    int lenX = Math.abs(endX - this.startX);
                    int lenY = Math.abs(endY - this.startY);
                    if (lenX >= lenY) {
                        x1 = Math.min(endX, this.startX);
                        x2 = x1 + lenX;
                        y1 = y2 = this.startY;
                        endY = this.startY;
                        break;
                    }
                    y1 = Math.min(endY, this.startY);
                    y2 = y1 + lenY;
                    x1 = x2 = this.startX;
                    endX = this.startX;
                    break;
                }
                case 3: {
                    x1 = Math.min(this.startX, endX);
                    y1 = Math.min(this.startY, endY);
                    x2 = Math.max(this.startX, endX);
                    y2 = Math.max(this.startY, endY);
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot handle callback without valid selection mode");
                }
            }
            result = this.selectionCallback.accept(x1, y1, x2, y2, endX, endY);
        }
        switch (result.ordinal()) {
            case 1: {
                this.startX = endX;
                this.startY = endY;
                this.selectStarted = true;
                break;
            }
            case 3: {
                this.selectStarted = false;
                this.selectMode = SelectMode.NONE;
                this.selectionCallback = null;
                break;
            }
            case 2: {
                this.selectStarted = false;
                break;
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int gridX = (int)((mouseX - (double)this.method_46426()) / (double)this.scale);
        int gridY = (int)((mouseY - (double)this.method_46427()) / (double)this.scale);
        if (gridX < 0 || gridX >= 16 || gridY < 0 || gridY >= 16) {
            return false;
        }
        if (this.placedComponent != null) {
            gridX /= 1;
            gridY /= 1;
            ComponentFootprint footprint = this.placedComponent.footprint();
            int offsetX = footprint.getWidth() / 2;
            int offsetY = footprint.getHeight() / 2;
            if (button == 0) {
                this.placementCallback.accept(gridX - offsetX, gridY - offsetY);
            }
            return true;
        }
        if (button == 0 && this.selectMode != SelectMode.NONE) {
            if (this.selectMode == SelectMode.POINT) {
                this.startX = gridX;
                this.startY = gridY;
                this.handleCallback(gridX, gridY);
            } else if (!this.selectStarted) {
                this.startX = gridX;
                this.startY = gridY;
                this.selectStarted = true;
                this.method_25354(class_310.method_1551().method_1483());
            } else {
                this.handleCallback(gridX, gridY);
            }
        } else if (button == 1) {
            this.cancelSelection();
        }
        return true;
    }

    public void requestSelection(SelectMode mode, int color, SelectCallback callback) {
        this.selectStarted = false;
        this.selectMode = mode;
        this.selectionColor = color;
        this.selectionCallback = callback;
    }

    public void setSelectionCancelledCallback(Runnable callback) {
        this.selectionCancelledCallback = callback;
    }

    public void cancelSelection() {
        if (this.selectMode != SelectMode.NONE) {
            this.selectMode = SelectMode.NONE;
            this.selectionCallback = null;
            this.selectStarted = false;
            if (this.selectionCancelledCallback != null) {
                this.selectionCancelledCallback.run();
            }
        }
    }

    public void componentPlacement(PlacedComponent component, BiConsumer<Integer, Integer> callback) {
        this.placedComponent = component;
        this.placementCallback = callback;
    }

    public void stopComponentPlacement() {
        this.placedComponent = null;
        this.placementCallback = null;
    }

    public static enum SelectMode {
        NONE,
        POINT,
        LINE,
        AREA;

    }

    public static interface SelectCallback {
        public SelectionResult accept(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static enum SelectionResult {
        IGNORE,
        CONTINUE,
        BEGIN_NEW,
        END;

    }
}

