/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.gui;

import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSoundEvents;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3414;
import net.minecraft.class_342;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.utility.Lang;

public class CircuitFileBox
extends class_342 {
    private int tick;
    private final List<String> availableSchematics = new ArrayList<String>();
    private int selectedIndex = 0;
    private boolean soundPlayed = false;
    private final List<class_2561> toolTip = new ArrayList<class_2561>();
    private final class_2561 title = Lang.translateDirect("gui.circuit_designer.files", new Object[0]);
    private final class_2561 scrollToSelect = Lang.translateDirect("gui.circuit_designer.file_scroll", new Object[0]);

    public CircuitFileBox(class_327 font, int x, int y, int width, int height, class_2561 message) {
        super(font, x, y, width, height, message);
        this.method_1868(-1);
        this.method_1858(false);
        this.method_1888(true);
        this.refreshFiles();
        this.onChanged();
    }

    public void method_1865() {
        super.method_1865();
        if (this.tick++ >= 20) {
            this.refreshFiles();
            this.tick = 0;
        }
        this.soundPlayed = false;
    }

    private void refreshFiles() {
        try {
            Files.createDirectories(Paths.get("circuits", new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            PowerGrid.LOGGER.error("Failed to create a folder", (Throwable)e);
        }
        this.availableSchematics.clear();
        try {
            Files.list(Paths.get("circuits/", new String[0])).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.getFileName().toString().endsWith(".nbt")).forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                this.availableSchematics.add(path.getFileName().toString());
            });
        }
        catch (NoSuchFileException e) {
        }
        catch (IOException e) {
            PowerGrid.LOGGER.error("Exception when loading circuit schematics", (Throwable)e);
        }
        this.availableSchematics.sort((aT, bT) -> {
            String a = aT;
            String b = bT;
            if (a.endsWith(".nbt")) {
                a = a.substring(0, a.length() - 4);
            }
            if (b.endsWith(".nbt")) {
                b = b.substring(0, b.length() - 4);
            }
            int aLength = a.length();
            int bLength = b.length();
            int minSize = Math.min(aLength, bLength);
            boolean asNumeric = false;
            int lastNumericCompare = 0;
            for (int i = 0; i < minSize; ++i) {
                boolean bNumber;
                char aChar = a.charAt(i);
                char bChar = b.charAt(i);
                boolean aNumber = aChar >= '0' && aChar <= '9';
                boolean bl = bNumber = bChar >= '0' && bChar <= '9';
                if (asNumeric) {
                    if (aNumber && bNumber) {
                        if (lastNumericCompare != 0) continue;
                        lastNumericCompare = aChar - bChar;
                        continue;
                    }
                    if (aNumber) {
                        return 1;
                    }
                    if (bNumber) {
                        return -1;
                    }
                    if (lastNumericCompare == 0) {
                        if (aChar != bChar) {
                            return aChar - bChar;
                        }
                        asNumeric = false;
                        continue;
                    }
                    return lastNumericCompare;
                }
                if (aNumber && bNumber) {
                    asNumeric = true;
                    if (lastNumericCompare != 0) continue;
                    lastNumericCompare = aChar - bChar;
                    continue;
                }
                if (aChar == bChar) continue;
                return aChar - bChar;
            }
            if (asNumeric) {
                if (aLength > bLength && a.charAt(bLength) >= '0' && a.charAt(bLength) <= '9') {
                    return 1;
                }
                if (bLength > aLength && b.charAt(aLength) >= '0' && b.charAt(aLength) <= '9') {
                    return -1;
                }
                if (lastNumericCompare == 0) {
                    return aLength - bLength;
                }
                return lastNumericCompare;
            }
            return aLength - bLength;
        });
        int prev = this.selectedIndex;
        this.clamp();
        if (prev != this.selectedIndex) {
            this.onChanged();
        }
        this.updateTooltip();
    }

    private void onChanged() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.availableSchematics.size()) {
            this.method_1852(this.availableSchematics.get(this.selectedIndex));
        }
        this.updateTooltip();
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int step = (int)(-Math.signum(delta)) * (AllKeys.shiftDown() ? 5 : 1);
        int priorState = this.selectedIndex;
        boolean shifted = AllKeys.shiftDown();
        this.selectedIndex += step;
        if (shifted) {
            this.selectedIndex -= this.selectedIndex % 5;
        }
        this.clamp();
        if (priorState != this.selectedIndex) {
            if (!this.soundPlayed) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)(1.5f + 0.1f * (float)this.selectedIndex / (float)(this.availableSchematics.size() - 1))));
            }
            this.soundPlayed = true;
            this.onChanged();
        }
        return priorState != this.selectedIndex;
    }

    private void clamp() {
        if (this.selectedIndex < 0) {
            this.selectedIndex = 0;
        }
        if (this.selectedIndex >= this.availableSchematics.size()) {
            this.selectedIndex = this.availableSchematics.size() - 1;
        }
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        this.toolTip.add((class_2561)this.title.method_27662().method_27694(s -> s.method_36139(AbstractSimiWidget.HEADER_RGB.getRGB())));
        int min = Math.min(this.availableSchematics.size() - 16, this.selectedIndex - 7);
        int max = Math.max(16, this.selectedIndex + 8);
        min = Math.max(min, 0);
        max = Math.min(max, this.availableSchematics.size());
        if (1 == min) {
            --min;
        }
        if (min > 0) {
            this.toolTip.add((class_2561)class_2561.method_43470((String)"> ...").method_27692(class_124.field_1080));
        }
        if (this.availableSchematics.size() - 1 == max) {
            ++max;
        }
        for (int i = min; i < max; ++i) {
            if (i == this.selectedIndex) {
                this.toolTip.add((class_2561)class_2561.method_43473().method_27693("-> ").method_27693(this.availableSchematics.get(i)).method_27692(class_124.field_1068));
                continue;
            }
            this.toolTip.add((class_2561)class_2561.method_43473().method_27693("> ").method_27693(this.availableSchematics.get(i)).method_27692(class_124.field_1080));
        }
        if (max < this.availableSchematics.size()) {
            this.toolTip.add((class_2561)class_2561.method_43470((String)"> ...").method_27692(class_124.field_1080));
        }
        this.toolTip.add((class_2561)this.scrollToSelect.method_27662().method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
    }

    public List<class_2561> getToolTip() {
        return this.toolTip;
    }
}

