/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.components.properties.BooleanProperty;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.components.properties.IntProperty;
import org.patryk3211.powergrid.circuits.components.properties.PropertyEntry;
import org.patryk3211.powergrid.circuits.components.properties.StringProperty;
import org.patryk3211.powergrid.circuits.gui.BooleanPropertyWidget;
import org.patryk3211.powergrid.circuits.gui.ConstantPropertyWidget;
import org.patryk3211.powergrid.circuits.gui.PropertyWidget;
import org.patryk3211.powergrid.circuits.gui.TextFieldPropertyWidget;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;

public class ComponentPropertiesWidget
extends AbstractSimiWidget {
    public static final class_2960 PROPERTIES = PowerGrid.texture("gui/circuit_design_table_properties");
    private final class_327 textRenderer;
    private final int right;
    @Nullable
    private PlacedComponent component;
    private final List<PropertyWidget<?, ?>> propertyWidgets = new ArrayList();
    private int propertyCount = 0;

    public ComponentPropertiesWidget(class_327 textRenderer, int right, int y) {
        super(right - 150, y, 150, 150);
        this.right = right;
        this.textRenderer = textRenderer;
    }

    public void setComponent(@Nullable PlacedComponent component) {
        this.component = component;
        this.propertyWidgets.clear();
        if (component != null) {
            ImmutableList<ComponentProperty<?>> properties = component.component.getProperties();
            class_5250 title = class_2561.method_43471((String)component.component.getRequiredItem().method_7876());
            int titleWidth = this.textRenderer.method_27525((class_5348)title);
            int maxTextLength = 0;
            for (ComponentProperty property : properties) {
                String propertyKey;
                int length;
                if (property.isHidden() || (length = this.textRenderer.method_27525((class_5348)class_2561.method_43471((String)(propertyKey = property.translationKey())))) <= maxTextLength) continue;
                maxTextLength = length;
            }
            int requiredWidth = Math.max(maxTextLength + 6 + 60 + 5, titleWidth + 20);
            int width = Math.max(requiredWidth, 120);
            this.method_25358(width);
            this.method_46421(this.right - width);
            int x = this.right - 60;
            int y = this.method_46427() + 16;
            for (ComponentProperty property : properties) {
                if (property.isHidden()) continue;
                if (property instanceof FloatProperty || property instanceof IntProperty || property instanceof StringProperty) {
                    this.propertyWidgets.add(new TextFieldPropertyWidget(this.textRenderer, x, y, component.getEntry(property)));
                } else if (property instanceof BooleanProperty) {
                    BooleanProperty bProp = (BooleanProperty)property;
                    this.propertyWidgets.add(new BooleanPropertyWidget(this.textRenderer, x, y, component.getEntry(bProp)));
                } else {
                    this.propertyWidgets.add(new ConstantPropertyWidget(this.textRenderer, x, y, component.getEntry(property)));
                }
                y += 20;
            }
            this.propertyCount = this.propertyWidgets.size();
        } else {
            this.method_25358(120);
            this.method_46421(this.right - 120);
            this.propertyCount = 0;
        }
    }

    protected void doRender(@NotNull class_332 ctx, int mouseX, int mouseY, float partialTicks) {
        if (this.component == null) {
            return;
        }
        class_4587 ms = ctx.method_51448();
        ms.method_46416((float)this.method_46426(), (float)this.method_46427(), 0.0f);
        int centerSliceSize = Math.max(this.field_22758 - 120, 0);
        ctx.method_25302(PROPERTIES, 0, 0, 0, 0, 60, 16);
        if (this.field_22758 > 120) {
            ctx.method_48585(PROPERTIES, 60, 0, centerSliceSize, 16, 61, 0, 30, 16);
        }
        ctx.method_25302(PROPERTIES, 60 + centerSliceSize, 0, 92, 0, 60, 16);
        String key = this.component.component.getRequiredItem().method_7876();
        ctx.method_27534(this.textRenderer, (class_2561)class_2561.method_43471((String)key), this.method_25368() / 2, 5, -1);
        ctx.method_48585(PROPERTIES, 0, 16, 60, this.propertyCount * 20, 0, 29, 60, 20);
        if (this.field_22758 > 120) {
            ctx.method_48585(PROPERTIES, 60, 16, centerSliceSize, this.propertyCount * 20, 61, 29, 30, 20);
        }
        ms.method_22903();
        ms.method_46416((float)(-this.method_46426()), (float)(-this.method_46427()), 0.0f);
        int yOffset = 16;
        for (PropertyWidget<?, ?> widget : this.propertyWidgets) {
            yOffset = widget.method_46427() + widget.method_25364() - this.method_46427();
            String propertyKey = ((PropertyEntry)widget.property).property.translationKey();
            int end = ctx.method_51439(this.textRenderer, (class_2561)class_2561.method_43471((String)propertyKey), this.method_46426() + 6, widget.method_46427() + 6, -10461088, false);
            widget.method_25394(ctx, mouseX, mouseY, partialTicks);
            class_5250 summary = class_2561.method_48321((String)(propertyKey + ".summary"), (String)"");
            if (summary.getString().isEmpty()) continue;
            int x1 = this.method_46426() + 6;
            int y1 = widget.method_46427() + 6;
            List lines = this.textRenderer.method_1728((class_5348)summary, this.method_25368());
            if (mouseX < x1 || mouseY < y1 || mouseX >= end || mouseY >= y1 + 16) continue;
            ctx.method_51447(this.textRenderer, lines, mouseX, mouseY);
        }
        ms.method_22909();
        ms.method_46416(0.0f, (float)yOffset, 0.0f);
        ctx.method_25302(PROPERTIES, 0, 0, 0, 50, 60, 6);
        if (this.field_22758 > 120) {
            ctx.method_48585(PROPERTIES, 60, 0, centerSliceSize, 6, 61, 50, 30, 6);
        }
        ctx.method_25302(PROPERTIES, 60 + centerSliceSize, 0, 92, 50, 60, 6);
        class_1799 stack = this.component.footprint().getRenderedStack();
        if (stack != null) {
            ctx.method_25302(PROPERTIES, this.method_25368() / 2 - 8, 4, 240, 0, 16, 10);
            ms.method_22903();
            ms.method_46416((float)(this.method_25368() / 2), 14.0f, 0.0f);
            ms.method_22905(3.0f, 3.0f, 1.0f);
            ms.method_46416(-8.0f, 0.0f, 0.0f);
            ctx.method_51427(stack, 0, 0);
            ms.method_22909();
        }
    }

    public void tick() {
        for (PropertyWidget<?, ?> widget : this.propertyWidgets) {
            widget.tick();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.component == null) {
            return false;
        }
        boolean result = false;
        for (PropertyWidget<?, ?> widget : this.propertyWidgets) {
            result |= widget.method_25402(mouseX, mouseY, button);
        }
        return result;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean result = false;
        for (PropertyWidget<?, ?> widget : this.propertyWidgets) {
            result |= widget.method_25404(keyCode, scanCode, modifiers);
        }
        return result;
    }

    public boolean method_25400(char chr, int modifiers) {
        boolean result = false;
        for (PropertyWidget<?, ?> widget : this.propertyWidgets) {
            result |= widget.method_25400(chr, modifiers);
        }
        return result;
    }
}

