/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.schematic;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.Line;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.circuits.schematic.Point;

@Environment(value=EnvType.CLIENT)
public class CircuitSchematicRender {
    public static final int COLOR_TERMINAL = -215549;
    public static final int COLOR_TRACE_FRONT = -1;
    public static final int COLOR_TRACE_BACK = -2130706433;
    public static final int COLOR_COMPONENT_OUTLINE = -2131724050;
    public static final int COLOR_SELECT_OUTLINE = -2132035020;

    public static void render(CircuitSchematic schematic, class_332 context, int x, int y, int scale) {
    }

    public static void renderLayer(List<Line> lines, class_332 ctx, int x, int y, int scale, int color) {
        for (Line line : lines) {
            int y2;
            int y1;
            int x2;
            int x1;
            if (line.vertical()) {
                x1 = line.position() * scale + x;
                x2 = line.position() * scale + scale + x;
                y1 = line.start() * scale + y;
                y2 = line.end() * scale + y;
            } else {
                x1 = line.start() * scale + x;
                x2 = line.end() * scale + x;
                y1 = line.position() * scale + y;
                y2 = line.position() * scale + scale + y;
            }
            ctx.method_25294(x1, y1, x2, y2, color);
        }
    }

    public static void renderPoints(List<Point> points, class_332 ctx, int x, int y, int scale, int color) {
        for (Point point : points) {
            int x1 = x + point.x() * scale;
            int y1 = y + point.y() * scale;
            ctx.method_25294(x1, y1, x1 + scale, y1 + scale, color);
        }
    }

    public static void renderComponents(CircuitSchematic schematic, class_332 ctx, int x, int y, int scale) {
        class_4587 ms = ctx.method_51448();
        ms.method_22903();
        ms.method_46416((float)x, (float)y, 0.0f);
        ms.method_22905((float)scale, (float)scale, (float)scale);
        for (PlacedComponent placed : schematic.components()) {
            placed.footprint().render(ctx, placed.x * 1, placed.y * 1, false);
        }
        ms.method_22909();
    }

    public static void renderComponents(CircuitSchematic schematic, class_332 ctx, int x, int y, int scale, int mouseX, int mouseY) {
        class_4587 ms = ctx.method_51448();
        ms.method_22903();
        ms.method_46416((float)x, (float)y, 0.0f);
        ms.method_22905((float)scale, (float)scale, (float)scale);
        int mX = (mouseX - x) / scale;
        int mY = (mouseY - y) / scale;
        for (PlacedComponent placed : schematic.components()) {
            boolean hovering = mX >= placed.x && mY >= placed.y && mX < placed.x + placed.footprint().getWidth() && mY < placed.y + placed.footprint().getHeight();
            placed.footprint().render(ctx, placed.x * 1, placed.y * 1, hovering);
        }
        ms.method_22909();
    }
}

