/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.thermal;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.patryk3211.powergrid.circuits.thermal.ThermalUnit;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;

public class ThermalBuilder {
    private final Set<AbstractElectricWire> sources = new HashSet<AbstractElectricWire>();
    private float overheatTemperature;
    private float thermalMass;
    private float dissipationFactor;
    private Consumer<Float> temperatureCallback;
    private Runnable overheatCallback;
    private final UUID componentUUID;
    private final int index;

    public ThermalBuilder(UUID componentUUID, int index) {
        this.componentUUID = componentUUID;
        this.index = index;
        this.overheatTemperature = 175.0f;
        this.thermalMass = 0.0f;
        this.dissipationFactor = 0.0f;
        this.temperatureCallback = null;
    }

    public ThermalBuilder addHeatSource(AbstractElectricWire wire) {
        this.sources.add(wire);
        return this;
    }

    public ThermalBuilder setThermalMass(float thermalMass) {
        this.thermalMass = thermalMass;
        return this;
    }

    public ThermalBuilder setMaxPower(float power, float temperature) {
        this.dissipationFactor = power / (temperature - 22.0f);
        return this;
    }

    public ThermalBuilder setMaxCurrent(float current, float resistance, float temperature) {
        return this.setMaxPower(resistance * current * current, temperature);
    }

    public ThermalBuilder setDissipationFactor(float dissipationFactor) {
        this.dissipationFactor = dissipationFactor;
        return this;
    }

    public ThermalBuilder setOverheatTemperature(float overheatTemperature) {
        this.overheatTemperature = overheatTemperature;
        return this;
    }

    public ThermalBuilder withTemperatureCallback(Consumer<Float> temperatureCallback) {
        this.temperatureCallback = temperatureCallback;
        return this;
    }

    public ThermalBuilder withOverheatCallback(Runnable overheatCallback) {
        this.overheatCallback = overheatCallback;
        return this;
    }

    public ThermalUnit build() {
        if (this.thermalMass == 0.0f) {
            throw new IllegalStateException("Thermal mass cannot be zero");
        }
        return new ThermalUnit(this.componentUUID, this.index, this.thermalMass, this.dissipationFactor, this.overheatTemperature, this.sources, this.temperatureCallback, this.overheatCallback);
    }

    public static interface IEmitter {
        public ThermalBuilder builder();
    }
}

