/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.collections;

import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_310;
import net.minecraft.class_7924;
import net.minecraft.class_918;
import org.apache.commons.lang3.mutable.MutableObject;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.collections.ModdedItems;

public class ItemDisplay {

    public static class BaseItemDisplay
    implements class_1761.class_7914 {
        private static final Predicate<class_1792> IS_ITEM_3D_PREDICATE;
        private final boolean addItems;

        public BaseItemDisplay(boolean addItems) {
            this.addItems = addItems;
        }

        private static Predicate<class_1792> makeExclusionPredicate() {
            ReferenceOpenHashSet exclusions = new ReferenceOpenHashSet();
            List<BlockEntry<CircuitBoardBlock>> simpleExclusions = List.of(ModdedItems.INCOMPLETE_TRANSFORMER_CORE, ModdedItems.INCOMPLETE_BATTERY, ModdedItems.INCOMPLETE_CIRCUIT, ModdedItems.INCOMPLETE_ELECTRICAL_GIZMO, ModdedItems.INCOMPLETE_UNETCHED_CIRCUIT, ModdedItems.PORTABLE_BATTERY_PLACEABLE, ModdedItems.CIRCUIT_SCHEMATIC, ModdedItems.UNETCHED_CIRCUIT, ModdedBlocks.CIRCUIT_BOARD);
            for (ItemProviderEntry itemProviderEntry : simpleExclusions) {
                exclusions.add(itemProviderEntry.method_8389());
            }
            return ((Set)exclusions)::contains;
        }

        private static List<ItemOrdering> makeOrderings() {
            ReferenceArrayList orderings = new ReferenceArrayList();
            return orderings;
        }

        private static Function<class_1792, class_1799> makeStackFunc() {
            Reference2ReferenceOpenHashMap factories = new Reference2ReferenceOpenHashMap();
            Map<ItemProviderEntry, Function> simpleFactories = Map.of();
            simpleFactories.forEach((arg_0, arg_1) -> BaseItemDisplay.lambda$makeStackFunc$4((Map)factories, arg_0, arg_1));
            return arg_0 -> BaseItemDisplay.lambda$makeStackFunc$5((Map)factories, arg_0);
        }

        private static Function<class_1792, class_1761.class_7705> makeVisibilityFunc() {
            Reference2ObjectOpenHashMap visibilities = new Reference2ObjectOpenHashMap();
            Map<ItemProviderEntry, class_1761.class_7705> simpleVisibilities = Map.of();
            simpleVisibilities.forEach((arg_0, arg_1) -> BaseItemDisplay.lambda$makeVisibilityFunc$6((Map)visibilities, arg_0, arg_1));
            return arg_0 -> BaseItemDisplay.lambda$makeVisibilityFunc$7((Map)visibilities, arg_0);
        }

        public void accept(class_1761.class_8128 parameters, class_1761.class_7704 output) {
            Predicate<class_1792> exclusionPredicate = BaseItemDisplay.makeExclusionPredicate();
            List<ItemOrdering> orderings = BaseItemDisplay.makeOrderings();
            Function<class_1792, class_1799> stackFunc = BaseItemDisplay.makeStackFunc();
            Function<class_1792, class_1761.class_7705> visibilityFunc = BaseItemDisplay.makeVisibilityFunc();
            LinkedList<class_1792> items = new LinkedList<class_1792>();
            if (this.addItems) {
                items.addAll(this.collectItems(exclusionPredicate.or(IS_ITEM_3D_PREDICATE.negate())));
            }
            items.addAll(this.collectBlocks(exclusionPredicate));
            if (this.addItems) {
                items.addAll(this.collectItems(exclusionPredicate.or(IS_ITEM_3D_PREDICATE)));
            }
            BaseItemDisplay.applyOrderings(items, orderings);
            BaseItemDisplay.outputAll(output, items, stackFunc, visibilityFunc);
        }

        private List<class_1792> collectBlocks(Predicate<class_1792> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : PowerGrid.REGISTRATE.getAll(class_7924.field_41254)) {
                class_1792 item = ((class_2248)entry.get()).method_8389();
                if (item == class_1802.field_8162 || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<class_1792> collectItems(Predicate<class_1792> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : PowerGrid.REGISTRATE.getAll(class_7924.field_41197)) {
                class_1792 item = (class_1792)entry.get();
                if (item instanceof class_1747 || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            return items;
        }

        private static void applyOrderings(List<class_1792> items, List<ItemOrdering> orderings) {
            for (ItemOrdering ordering : orderings) {
                int anchorIndex = items.indexOf(ordering.anchor());
                if (anchorIndex == -1) continue;
                class_1792 item = ordering.item();
                int itemIndex = items.indexOf(item);
                if (itemIndex != -1) {
                    items.remove(itemIndex);
                    if (itemIndex < anchorIndex) {
                        --anchorIndex;
                    }
                }
                if (ordering.type() == ItemOrdering.Type.AFTER) {
                    items.add(anchorIndex + 1, item);
                    continue;
                }
                items.add(anchorIndex, item);
            }
        }

        private static void outputAll(class_1761.class_7704 output, List<class_1792> items, Function<class_1792, class_1799> stackFunc, Function<class_1792, class_1761.class_7705> visibilityFunc) {
            for (class_1792 item : items) {
                output.method_45417(stackFunc.apply(item), visibilityFunc.apply(item));
            }
        }

        private static /* synthetic */ class_1761.class_7705 lambda$makeVisibilityFunc$7(Map visibilities, class_1792 item) {
            class_1761.class_7705 visibility = (class_1761.class_7705)visibilities.get(item);
            if (visibility != null) {
                return visibility;
            }
            return class_1761.class_7705.field_40191;
        }

        private static /* synthetic */ void lambda$makeVisibilityFunc$6(Map visibilities, ItemProviderEntry entry, class_1761.class_7705 factory) {
            visibilities.put(entry.method_8389(), factory);
        }

        private static /* synthetic */ class_1799 lambda$makeStackFunc$5(Map factories, class_1792 item) {
            Function factory = (Function)factories.get(item);
            if (factory != null) {
                return (class_1799)factory.apply(item);
            }
            return new class_1799((class_1935)item);
        }

        private static /* synthetic */ void lambda$makeStackFunc$4(Map factories, ItemProviderEntry entry, Function factory) {
            factories.put(entry.method_8389(), factory);
        }

        static {
            MutableObject isItem3d = new MutableObject(item -> false);
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> isItem3d.setValue(item -> {
                class_918 itemRenderer = class_310.method_1551().method_1480();
                class_1087 model = itemRenderer.method_4019(new class_1799((class_1935)item), null, null, 0);
                return model.method_4712();
            }));
            IS_ITEM_3D_PREDICATE = (Predicate)isItem3d.getValue();
        }

        private record ItemOrdering(class_1792 item, class_1792 anchor, Type type) {
            public static ItemOrdering before(class_1792 item, class_1792 anchor) {
                return new ItemOrdering(item, anchor, Type.BEFORE);
            }

            public static ItemOrdering after(class_1792 item, class_1792 anchor) {
                return new ItemOrdering(item, anchor, Type.AFTER);
            }

            public static enum Type {
                BEFORE,
                AFTER;

            }
        }
    }
}

