/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.config;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.config.ResistanceValues;

public class CResistance
extends ConfigBase
implements ResistanceValues.Provider {
    private static final int VERSION = 3;
    private static final Object2DoubleMap<class_2960> DEFAULT_RESISTANCES = new Object2DoubleOpenHashMap();
    protected final Map<class_2960, ForgeConfigSpec.ConfigValue<Double>> resistances = new HashMap<class_2960, ForgeConfigSpec.ConfigValue<Double>>();

    public void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{".", Comments.ohm, Comments.resistance}).push("resistance");
        DEFAULT_RESISTANCES.forEach((id, value) -> this.resistances.put((class_2960)id, (ForgeConfigSpec.ConfigValue<Double>)builder.define(id.method_12832(), value)));
        builder.pop();
    }

    public String getName() {
        return "resistance-v3";
    }

    @Override
    @Nullable
    public DoubleSupplier get(class_2248 block) {
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        ForgeConfigSpec.ConfigValue<Double> entry = this.resistances.get(id);
        return entry == null ? null : () -> entry.get();
    }

    @Override
    @Nullable
    public DoubleSupplier get(class_2248 block, String suffix) {
        class_2960 id = class_7923.field_41175.method_10221((Object)block).method_48331("." + suffix);
        ForgeConfigSpec.ConfigValue<Double> entry = this.resistances.get(id);
        return entry == null ? null : () -> entry.get();
    }

    public static <B extends class_2248, P> NonNullUnaryOperator<BlockBuilder<B, P>> setResistance(double value) {
        return builder -> {
            CResistance.assertFromPowerGrid(builder);
            class_2960 id = PowerGrid.asResource(builder.getName());
            DEFAULT_RESISTANCES.put((Object)id, value);
            return builder;
        };
    }

    public static <B extends class_2248, P> NonNullUnaryOperator<BlockBuilder<B, P>> setResistance(String suffix, double value) {
        return builder -> {
            CResistance.assertFromPowerGrid(builder);
            class_2960 id = PowerGrid.asResource(builder.getName()).method_48331("." + suffix);
            DEFAULT_RESISTANCES.put((Object)id, value);
            return builder;
        };
    }

    public static <B extends class_2248, P> NonNullUnaryOperator<BlockBuilder<B, P>> setResistances(Object ... suffixValuePairs) {
        return builder -> {
            CResistance.assertFromPowerGrid(builder);
            for (int i = 0; i < suffixValuePairs.length; i += 2) {
                String suffix = (String)suffixValuePairs[i];
                Number value = (Number)suffixValuePairs[i + 1];
                class_2960 id = PowerGrid.asResource(builder.getName()).method_48331("." + suffix);
                DEFAULT_RESISTANCES.put((Object)id, value.doubleValue());
            }
            return builder;
        };
    }

    private static void assertFromPowerGrid(BlockBuilder<?, ?> builder) {
        if (!builder.getOwner().getModid().equals("powergrid")) {
            throw new IllegalStateException("Non-Power Grid blocks cannot be added to Power Grid's config.");
        }
    }

    private static class Comments {
        static String ohm = "[in Ohms]";
        static String resistance = "Configure the individual resistances of electrical blocks";

        private Comments() {
        }
    }
}

