/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.data.recipes;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2456;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7784;
import net.minecraft.class_7800;
import net.minecraft.class_8074;
import org.patryk3211.powergrid.PowerGrid;

public abstract class StandardRecipeProvider
extends BaseRecipeProvider {
    String currentFolder = "";

    public StandardRecipeProvider(class_7784 output) {
        super(output, "powergrid");
    }

    Marker enterFolder(String folder) {
        this.currentFolder = folder;
        return new Marker();
    }

    GeneratedRecipeBuilder create(Supplier<class_1935> result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(class_2960 result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends class_1935> result) {
        return this.create((Supplier<class_1935>)((Supplier)() -> result.get()));
    }

    BaseRecipeProvider.GeneratedRecipe createSpecial(Supplier<? extends class_1866<?>> serializer, String recipeType, String path) {
        class_2960 location = PowerGrid.asResource(recipeType + "/" + this.currentFolder + "/" + path);
        return this.register(consumer -> {
            class_2456 b = class_2456.method_10476((class_1865)((class_1865)serializer.get()));
            b.method_10475(consumer, location.toString());
        });
    }

    BaseRecipeProvider.GeneratedRecipe conversionCycle(List<ItemProviderEntry<? extends class_1935>> cycle) {
        BaseRecipeProvider.GeneratedRecipe result = null;
        for (int i = 0; i < cycle.size(); ++i) {
            ItemProviderEntry<? extends class_1935> currentEntry = cycle.get(i);
            ItemProviderEntry<? extends class_1935> nextEntry = cycle.get((i + 1) % cycle.size());
            result = this.create(nextEntry).withSuffix("_from_conversion").unlockedBy((Supplier<? extends class_1935>)((Supplier)() -> currentEntry.get())).viaShapeless(b -> b.method_10454((class_1935)currentEntry.get()));
        }
        return result;
    }

    BaseRecipeProvider.GeneratedRecipe clearData(ItemProviderEntry<? extends class_1935> item) {
        return this.create(item).withSuffix("_clear").unlockedBy((Supplier<? extends class_1935>)((Supplier)() -> item.get())).viaShapeless(b -> b.method_10454((class_1935)item.get()));
    }

    public void method_10419(Consumer<class_2444> p_200404_1_) {
        this.all.forEach(c -> c.register(p_200404_1_));
        PowerGrid.LOGGER.info(this.method_10321() + " registered " + this.all.size() + " recipe" + (this.all.size() == 1 ? "" : "s"));
    }

    protected BaseRecipeProvider.GeneratedRecipe register(BaseRecipeProvider.GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    public String method_10321() {
        return this.modid + "'s Standard Recipes";
    }

    static class Marker {
        Marker() {
        }
    }

    class GeneratedRecipeBuilder {
        private String path;
        private String suffix;
        private Supplier<? extends class_1935> result;
        private class_2960 compatDatagenOutput;
        private Supplier<class_2073> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends class_1935> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, class_2960 result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends class_1935> item) {
            this.unlockedBy = () -> class_2073.class_2074.method_8973().method_8977(new class_1935[]{(class_1935)item.get()}).method_8976();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<class_6862<class_1792>> tag) {
            this.unlockedBy = () -> class_2073.class_2074.method_8973().method_8975((class_6862)tag.get()).method_8976();
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        BaseRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<class_2447> builder) {
            return StandardRecipeProvider.this.register(consumer -> {
                class_2447 b = (class_2447)builder.apply(class_2447.method_10436((class_7800)class_7800.field_40642, (class_1935)((class_1935)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.method_10429("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{(class_2073)this.unlockedBy.get()}));
                }
                b.method_17972(consumer, this.createLocation("crafting"));
            });
        }

        BaseRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<class_2450> builder) {
            return StandardRecipeProvider.this.register(consumer -> {
                class_2450 b = (class_2450)builder.apply(class_2450.method_10448((class_7800)class_7800.field_40642, (class_1935)((class_1935)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.method_10442("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{(class_2073)this.unlockedBy.get()}));
                }
                b.method_17972(consumer, this.createLocation("crafting"));
            });
        }

        BaseRecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends class_1792> base, Supplier<class_1856> upgradeMaterial) {
            return StandardRecipeProvider.this.register(consumer -> {
                class_8074 b = class_8074.method_48535((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_41946}), (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)base.get()}), (class_1856)((class_1856)upgradeMaterial.get()), (class_7800)class_7800.field_40639, (class_1792)((class_1935)this.result.get()).method_8389());
                b.method_48536("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(new class_1935[]{(class_1935)base.get()}).method_8976()}));
                b.method_48537(consumer, this.createLocation("crafting"));
            });
        }

        private class_2960 createSimpleLocation(String recipeType) {
            return PowerGrid.asResource(recipeType + "/" + this.getRegistryName().method_12832() + this.suffix);
        }

        private class_2960 createLocation(String recipeType) {
            return PowerGrid.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().method_12832() + this.suffix);
        }

        private class_2960 getRegistryName() {
            return this.compatDatagenOutput == null ? CatnipServices.REGISTRIES.getKeyOrThrow(((class_1935)this.result.get()).method_8389()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends class_1935> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<class_1856>)((Supplier)() -> class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<class_6862<class_1792>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<class_1856>)((Supplier)() -> class_1856.method_8106((class_6862)((class_6862)tag.get()))));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<class_1856> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private Supplier<class_1856> ingredient;
            private float exp;
            private int cookingTime;
            private final class_1865<? extends class_1874> FURNACE = class_1865.field_9042;
            private final class_1865<? extends class_1874> SMOKER = class_1865.field_17085;
            private final class_1865<? extends class_1874> BLAST = class_1865.field_17084;
            private final class_1865<? extends class_1874> CAMPFIRE = class_1865.field_17347;

            GeneratedCookingRecipeBuilder(Supplier<class_1856> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<class_2454> builder) {
                return this.create(this.FURNACE, builder, 1.0f);
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<class_2454> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                this.create(this.CAMPFIRE, builder, 3.0f);
                return this.create(this.SMOKER, builder, 0.5f);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<class_2454> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                return this.create(this.BLAST, builder, 0.5f);
            }

            private BaseRecipeProvider.GeneratedRecipe create(class_1865<? extends class_1874> serializer, UnaryOperator<class_2454> builder, float cookingTimeModifier) {
                return StandardRecipeProvider.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    class_2454 b = (class_2454)builder.apply(class_2454.method_17801((class_1856)((class_1856)this.ingredient.get()), (class_7800)class_7800.field_40642, (class_1935)(isOtherMod ? class_1802.field_8831 : (class_1935)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (class_1865)serializer));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.method_10469("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{(class_2073)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.method_17972(result -> consumer.accept(isOtherMod ? new ModdedCookingRecipeResult((class_2444)result, GeneratedRecipeBuilder.this.compatDatagenOutput) : result), GeneratedRecipeBuilder.this.createSimpleLocation(CatnipServices.REGISTRIES.getKeyOrThrow(serializer).method_12832()));
                });
            }
        }
    }

    private record ModdedCookingRecipeResult(class_2444 wrapped, class_2960 outputOverride) implements class_2444
    {
        public class_2960 method_10417() {
            return this.wrapped.method_10417();
        }

        public class_1865<?> method_17800() {
            return this.wrapped.method_17800();
        }

        public JsonObject method_10415() {
            return this.wrapped.method_10415();
        }

        public class_2960 method_10418() {
            return this.wrapped.method_10418();
        }

        public void method_10416(JsonObject object) {
            this.wrapped.method_10416(object);
            object.addProperty("result", this.outputOverride.toString());
        }
    }
}

