/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.createmod.ponder.api.level.PonderLevel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.ClientWorldNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEntity;
import org.patryk3211.powergrid.utility.NumberFormats;

public class GlobalElectricNetworks {
    protected static final Map<class_1937, WorldNetworks> worldNetworks = new ConcurrentHashMap<class_1937, WorldNetworks>();

    public static void tick(class_1937 world) {
        WorldNetworks networks = worldNetworks.get(world);
        if (networks == null) {
            return;
        }
        networks.tick();
    }

    public static void unloadWorld(class_3218 world) {
        worldNetworks.remove(world);
    }

    @Environment(value=EnvType.CLIENT)
    public static WorldNetworks makeClientWorldNetworks(class_1937 world) {
        return new ClientWorldNetworks(world);
    }

    public static WorldNetworks getWorldNetworks(class_1937 world) {
        return worldNetworks.computeIfAbsent(world, key -> {
            if (key instanceof PonderLevel) {
                return new WorldNetworks((class_1937)key);
            }
            if (key.field_9236) {
                return GlobalElectricNetworks.makeClientWorldNetworks(key);
            }
            if (world instanceof class_3218) {
                class_3218 server = (class_3218)world;
                return (WorldNetworks)server.method_17983().method_17924(nbt -> new WorldNetworks(world, (class_2487)nbt), () -> new WorldNetworks(world), "powergrid_electric_network_data");
            }
            return new WorldNetworks(world);
        });
    }

    @Nullable
    public static WorldNetworks getWorldNetworks(class_1936 world) {
        return worldNetworks.get(world);
    }

    public static TransmissionLine getLine(WireEntity entity) {
        OwnedFloatingNode owned;
        Object line;
        ElectricWire wire = entity.getWire();
        if (wire == null) {
            return null;
        }
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(entity.method_37908());
        IElectricNode iElectricNode = wire.getNode1();
        if (iElectricNode instanceof OwnedFloatingNode && (line = worldNetworks.findLineMiddle(owned = (OwnedFloatingNode)iElectricNode)) != null && ((TransmissionLine)line).isPart(wire)) {
            return line;
        }
        line = wire.getNode2();
        if (line instanceof OwnedFloatingNode && (line = worldNetworks.findLineMiddle(owned = (OwnedFloatingNode)line)) != null && ((TransmissionLine)line).isPart(wire)) {
            return line;
        }
        AbstractElectricWire lineWire = worldNetworks.globalGraph.getFirstWire(wire.getNode1(), wire.getNode2());
        if (lineWire instanceof TransmissionLine) {
            TransmissionLine line1 = (TransmissionLine)lineWire;
            return line1;
        }
        return null;
    }

    public static ElectricWire makeConnection(class_1937 world, IWireEndpoint endpoint1, IWireEndpoint endpoint2, BaseWireEntity forEntity, WorldNetworks.PartId id) {
        return GlobalElectricNetworks.getWorldNetworks(world).makeTransmissionLine(endpoint1, endpoint2, forEntity, id);
    }

    private static class_2561 display(IElectricNode node) {
        class_5250 line;
        if (node instanceof OwnedFloatingNode) {
            OwnedFloatingNode ofn = (OwnedFloatingNode)node;
            line = class_2561.method_43470((String)("OFN[" + String.valueOf(ofn.endpoint) + "]"));
        } else {
            line = class_2561.method_43470((String)node.toString());
        }
        line.method_10852((class_2561)class_2561.method_43470((String)("@" + NumberFormats.formatPrecise(node.getVoltage()) + "V")).method_27692(class_124.field_1063));
        if (node.getNetwork() != null) {
            if (node.getNetwork().isLeaf(node)) {
                line.method_10852((class_2561)class_2561.method_43470((String)" -").method_27692(class_124.field_1060));
            } else if (node.getNetwork().isOptimized(node)) {
                line.method_10852((class_2561)class_2561.method_43470((String)" *").method_27692(class_124.field_1060));
            }
        }
        return line;
    }

    public static void inspect(ElectricBehaviour behaviour, class_1657 user) {
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(user.method_37908());
        user.method_43496((class_2561)(user instanceof class_3222 ? class_2561.method_43470((String)"Server:").method_27692(class_124.field_1065) : class_2561.method_43470((String)"Client:").method_27692(class_124.field_1060)));
        int index = 0;
        for (OwnedFloatingNode node : behaviour.getExternalNodes()) {
            user.method_43496((class_2561)class_2561.method_43470((String)(index++ + " = ")).method_10852(GlobalElectricNetworks.display(node)).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
            for (IElectricNode connected : worldNetworks.globalGraph.getConnectedNodes(node)) {
                user.method_43496((class_2561)class_2561.method_43470((String)" - ").method_10852(GlobalElectricNetworks.display(connected)).method_27692(class_124.field_1078));
                for (AbstractElectricWire wire : worldNetworks.globalGraph.getWires(node, connected)) {
                    user.method_43496((class_2561)class_2561.method_43470((String)("    via " + String.valueOf(wire))).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
                }
            }
        }
    }

    public static void nodeHolderUnloaded(ElectricBehaviour behaviour) {
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(behaviour.blockEntity.method_10997());
        for (IElectricNode iElectricNode : behaviour.getExternalNodes()) {
            if (!(iElectricNode instanceof OwnedFloatingNode)) continue;
            OwnedFloatingNode ownedNode = (OwnedFloatingNode)iElectricNode;
            worldNetworks.nodeHolderUnloaded(ownedNode);
        }
    }

    public static void nodeHolderRemoved(ElectricBehaviour behaviour) {
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(behaviour.blockEntity.method_10997());
        for (IElectricNode iElectricNode : behaviour.getExternalNodes()) {
            if (!(iElectricNode instanceof OwnedFloatingNode)) continue;
            OwnedFloatingNode ownedNode = (OwnedFloatingNode)iElectricNode;
            worldNetworks.nodeHolderRemoved(ownedNode);
        }
    }

    public static void nodeHolderAdded(ElectricBehaviour behaviour) {
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(behaviour.blockEntity.method_10997());
        for (OwnedFloatingNode node : behaviour.getExternalNodes()) {
            worldNetworks.nodeHolderAdded(node, behaviour.hasInternals());
        }
    }

    public static void prepareUnpaused(ElectricBehaviour behaviour) {
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(behaviour.blockEntity.method_10997());
        for (OwnedFloatingNode node : behaviour.getExternalNodes()) {
            worldNetworks.prepareUnpaused(node);
        }
    }
}

