/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import org.patryk3211.powergrid.circuits.circuitboard.BakedCircuit;
import org.patryk3211.powergrid.config.ResistanceValues;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.TransformerCoupling;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;

public interface IElectricEntity {
    public void buildCircuit(CircuitBuilder var1);

    default public float resistance() {
        IElectricEntity iElectricEntity = this;
        if (iElectricEntity instanceof class_2586) {
            class_2586 be = (class_2586)iElectricEntity;
            return ResistanceValues.get(be.method_11010().method_26204());
        }
        throw new IllegalCallerException("Cannot get resistance if not extending a block entity");
    }

    default public float resistance(String suffix) {
        IElectricEntity iElectricEntity = this;
        if (iElectricEntity instanceof class_2586) {
            class_2586 be = (class_2586)iElectricEntity;
            return ResistanceValues.get(be.method_11010().method_26204(), suffix);
        }
        throw new IllegalCallerException("Cannot get resistance if not extending a block entity");
    }

    default public void paused() {
    }

    default public void unpaused() {
    }

    public static class CircuitBuilder {
        private ElectricalNetwork network;
        private final class_2338 pos;
        private final List<OwnedFloatingNode> externalNodes;
        private final Collection<INode> internalNodes;
        private final Collection<AbstractElectricWire> wires;
        private boolean paused = false;

        public CircuitBuilder(class_2338 pos, List<OwnedFloatingNode> externalNodes, Collection<INode> internalNodes, Collection<AbstractElectricWire> wires) {
            this.pos = pos;
            this.externalNodes = externalNodes;
            this.internalNodes = internalNodes;
            this.wires = wires;
        }

        public CircuitBuilder with(ElectricalNetwork network) {
            this.network = network;
            return this;
        }

        public void clear() {
            if (this.network != null) {
                this.wires.forEach(this.network::removeWire);
                this.internalNodes.forEach(this.network::removeNode);
                this.externalNodes.forEach(this.network::removeNode);
            }
            this.externalNodes.clear();
            this.internalNodes.clear();
            this.wires.clear();
        }

        protected void addExternalNode() {
            int index = this.externalNodes.size();
            OwnedFloatingNode node = new OwnedFloatingNode(new BlockWireEndpoint(this.pos, index));
            this.externalNodes.add(node);
            if (this.network != null) {
                this.network.addNode((INode)node);
            }
        }

        public <T extends INode> T addInternalNode(Class<T> clazz, Object ... params) {
            try {
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    Class<?>[] paramTypes = constructor.getParameterTypes();
                    if (params.length != paramTypes.length) continue;
                    boolean valid = true;
                    for (int i = 0; i < params.length; ++i) {
                        if (paramTypes[i].isInstance(params[i])) continue;
                        valid = false;
                        break;
                    }
                    if (!valid) continue;
                    INode node = (INode)constructor.newInstance(params);
                    this.add(node);
                    return (T)node;
                }
                throw new NoSuchMethodException();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public FloatingNode addInternalNode() {
            FloatingNode node = new FloatingNode();
            this.add(node);
            return node;
        }

        public FloatingNode terminalNode(int index) {
            return this.externalNodes.get(index);
        }

        public void setTerminalCount(int count) {
            block4: {
                int currentCount = this.externalNodes.size();
                if (currentCount == count) break block4;
                if (currentCount < count) {
                    for (int i = 0; i < count - currentCount; ++i) {
                        this.addExternalNode();
                    }
                } else {
                    for (int i = 0; i < currentCount - count; ++i) {
                        OwnedFloatingNode node = this.externalNodes.remove(this.externalNodes.size() - 1);
                        if (this.network == null) continue;
                        this.network.removeNode(node);
                    }
                }
            }
        }

        public ElectricWire connect(float resistance, IElectricNode node1, IElectricNode node2) {
            ElectricWire wire = new ElectricWire(resistance, node1, node2);
            this.add(wire);
            return wire;
        }

        public SwitchedWire connectSwitch(float resistance, IElectricNode node1, IElectricNode node2, boolean state) {
            SwitchedWire wire = new SwitchedWire(resistance, node1, node2, state);
            this.add(wire);
            return wire;
        }

        public void add(AbstractElectricWire wire) {
            this.wires.add(wire);
            if (this.network != null && !this.paused) {
                this.network.addWire(wire);
            }
        }

        public void add(INode node) {
            this.internalNodes.add(node);
            if (this.network != null && !this.paused) {
                this.network.addNode(node);
            }
        }

        public SwitchedWire connectSwitch(float resistance, IElectricNode node1, IElectricNode node2) {
            return this.connectSwitch(resistance, node1, node2, true);
        }

        public TransformerCoupling couple(float ratio, float resistance, IElectricNode p1, IElectricNode s1) {
            TransformerCoupling node = TransformerCoupling.create(ratio, resistance, p1, s1);
            this.add(node);
            return node;
        }

        public TransformerCoupling couple(float ratio, float resistance, IElectricNode p1, IElectricNode s1, IElectricNode s2) {
            TransformerCoupling node = TransformerCoupling.create(ratio, resistance, p1, s1, s2);
            this.add(node);
            return node;
        }

        public TransformerCoupling couple(float ratio, float resistance, IElectricNode p1, IElectricNode p2, IElectricNode s1, IElectricNode s2) {
            TransformerCoupling node = TransformerCoupling.create(ratio, resistance, p1, p2, s1, s2);
            this.add(node);
            return node;
        }

        public TransformerCoupling couple(float ratio, IElectricNode p1, IElectricNode s1) {
            TransformerCoupling node = TransformerCoupling.create(ratio, p1, s1);
            this.add(node);
            return node;
        }

        public TransformerCoupling couple(float ratio, IElectricNode p1, IElectricNode s1, IElectricNode s2) {
            TransformerCoupling node = TransformerCoupling.create(ratio, p1, s1, s2);
            this.add(node);
            return node;
        }

        public TransformerCoupling couple(float ratio, IElectricNode p1, IElectricNode p2, IElectricNode s1, IElectricNode s2) {
            TransformerCoupling node = TransformerCoupling.create(ratio, p1, p2, s1, s2);
            this.add(node);
            return node;
        }

        public void setTo(BakedCircuit circuit) {
            this.clear();
            for (OwnedFloatingNode ownedFloatingNode : circuit.externalNodes) {
                this.externalNodes.add(ownedFloatingNode);
                if (this.network == null) continue;
                this.network.addNode((INode)ownedFloatingNode);
            }
            for (INode iNode : circuit.internalNodes) {
                this.internalNodes.add(iNode);
                if (this.network == null || this.paused) continue;
                this.network.addNode(iNode);
            }
            for (AbstractElectricWire abstractElectricWire : circuit.wires) {
                this.wires.add(abstractElectricWire);
                if (this.network == null || this.paused) continue;
                this.network.addWire(abstractElectricWire);
            }
        }

        public void paused() {
            this.paused = true;
        }
    }
}

