/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;

public class ProxyElectricBehaviour
extends ElectricBehaviour {
    protected final Supplier<class_2338> behaviourPosition;

    public <T extends SmartBlockEntity> ProxyElectricBehaviour(T be, Supplier<class_2338> behaviourPosition) {
        super(be, false);
        this.behaviourPosition = behaviourPosition;
    }

    protected <T extends SmartBlockEntity> ProxyElectricBehaviour(T be, boolean buildCircuit, Supplier<class_2338> behaviourPosition) {
        super(be, buildCircuit);
        this.behaviourPosition = behaviourPosition;
    }

    public Optional<ElectricBehaviour> getMainBehaviour() {
        class_2338 pos = this.behaviourPosition.get();
        if (this.getPos().equals((Object)pos) || pos == null) {
            return Optional.empty();
        }
        if (!this.getWorld().method_8477(pos)) {
            return Optional.empty();
        }
        return Optional.ofNullable((ElectricBehaviour)ProxyElectricBehaviour.get((class_1922)this.getWorld(), (class_2338)pos, (BehaviourType)TYPE));
    }

    @Override
    public void joinNetwork(ElectricalNetwork network) {
        if (this.hasInternals()) {
            this.getMainBehaviour().ifPresentOrElse(b -> b.joinNetwork(network), () -> super.joinNetwork(network));
        } else {
            this.getMainBehaviour().ifPresent(b -> b.joinNetwork(network));
        }
    }

    @Override
    @Nullable
    public OwnedFloatingNode getTerminal(int index) {
        return this.getMainBehaviour().map(b -> b.getTerminal(index)).orElseGet(() -> super.getTerminal(index));
    }

    @Override
    public boolean hasTerminal(int terminal) {
        return this.getMainBehaviour().map(b -> b.hasTerminal(terminal)).orElseGet(() -> super.hasTerminal(terminal));
    }

    @Override
    public List<OwnedFloatingNode> getExternalNodes() {
        return this.getMainBehaviour().map(ElectricBehaviour::getExternalNodes).orElseGet(() -> super.getExternalNodes());
    }

    @Override
    public void initialize() {
        this.refreshEndpoints();
    }

    public void refreshEndpoints() {
        for (OwnedFloatingNode node : this.getExternalNodes()) {
            IWireEndpoint iWireEndpoint = node.endpoint;
            if (!(iWireEndpoint instanceof BlockWireEndpoint)) continue;
            BlockWireEndpoint endpoint = (BlockWireEndpoint)iWireEndpoint;
            BlockWireEndpoint thisEndpoint = new BlockWireEndpoint(this.getPos(), endpoint.getTerminal());
            GlobalElectricNetworks.getWorldNetworks(this.getWorld()).addAndMigrateNode(thisEndpoint, node);
        }
    }

    @Override
    public void unload() {
    }

    @Override
    public void remove() {
        this.breakConnections();
    }

    public void baseInitialize() {
        super.initialize();
    }

    protected void baseUnload() {
        super.unload();
    }

    protected void baseRemove() {
        super.remove();
    }
}

