/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;

public class TerminalBoundingBox
implements ITerminalPlacement,
IDecoratedTerminal {
    private class_243 min;
    private class_243 max;
    private class_243 origin;
    private double expand;
    private final class_2561 name;
    private int color;

    private TerminalBoundingBox(class_2561 name) {
        this.name = name;
        this.color = 0xAAAAAA;
    }

    private TerminalBoundingBox(TerminalBoundingBox other) {
        this.name = other.name;
        this.color = other.color;
        this.expand = other.expand;
        this.min = other.min;
        this.max = other.max;
        this.origin = other.origin;
    }

    public TerminalBoundingBox(class_2561 name, double x1, double y1, double z1, double x2, double y2, double z2) {
        this(name, x1, y1, z1, x2, y2, z2, 0.1);
    }

    public TerminalBoundingBox(class_2561 name, double x1, double y1, double z1, double x2, double y2, double z2, double expand) {
        this(name);
        this.min = new class_243((x1 - expand) / 16.0, (y1 - expand) / 16.0, (z1 - expand) / 16.0);
        this.max = new class_243((x2 + expand) / 16.0, (y2 + expand) / 16.0, (z2 + expand) / 16.0);
        this.origin = new class_243((x1 + x2) * 0.03125, (y1 + y2) * 0.03125, (z1 + z2) * 0.03125);
        this.expand = expand / 16.0;
    }

    public TerminalBoundingBox(class_2561 name, class_238 boundingBox) {
        this(name, boundingBox.field_1323 * 16.0, boundingBox.field_1322 * 16.0, boundingBox.field_1321 * 16.0, boundingBox.field_1320 * 16.0, boundingBox.field_1325 * 16.0, boundingBox.field_1324 * 16.0, 0.1);
    }

    public class_265 getShape() {
        return class_259.method_1081((double)(this.min.field_1352 + this.expand), (double)(this.min.field_1351 + this.expand), (double)(this.min.field_1350 + this.expand), (double)(this.max.field_1352 - this.expand), (double)(this.max.field_1351 - this.expand), (double)(this.max.field_1350 - this.expand));
    }

    public TerminalBoundingBox offset(class_243 offset) {
        return this.offset(offset.field_1352, offset.field_1351, offset.field_1350);
    }

    public TerminalBoundingBox offset(double x, double y, double z) {
        TerminalBoundingBox terminal = new TerminalBoundingBox(this);
        terminal.min = terminal.min.method_1031(x, y, z);
        terminal.max = terminal.max.method_1031(x, y, z);
        terminal.origin = terminal.origin.method_1031(x, y, z);
        return terminal;
    }

    public TerminalBoundingBox rotateAroundX(class_2470 rotation) {
        TerminalBoundingBox terminal = new TerminalBoundingBox(this);
        switch (rotation) {
            case field_11467: {
                terminal.min = this.min;
                terminal.max = this.max;
                terminal.origin = this.origin;
                break;
            }
            case field_11463: {
                terminal.min = new class_243(this.min.field_1352, this.min.field_1350, 1.0 - this.max.field_1351);
                terminal.max = new class_243(this.max.field_1352, this.max.field_1350, 1.0 - this.min.field_1351);
                terminal.origin = new class_243(this.origin.field_1352, this.origin.field_1350, 1.0 - this.origin.field_1351);
                break;
            }
            case field_11464: {
                terminal.min = new class_243(this.min.field_1352, 1.0 - this.max.field_1351, 1.0 - this.max.field_1350);
                terminal.max = new class_243(this.max.field_1352, 1.0 - this.min.field_1351, 1.0 - this.min.field_1350);
                terminal.origin = new class_243(this.origin.field_1352, 1.0 - this.origin.field_1351, 1.0 - this.origin.field_1350);
                break;
            }
            case field_11465: {
                terminal.min = new class_243(this.min.field_1352, 1.0 - this.max.field_1350, this.min.field_1351);
                terminal.max = new class_243(this.max.field_1352, 1.0 - this.min.field_1350, this.max.field_1351);
                terminal.origin = new class_243(this.origin.field_1352, 1.0 - this.origin.field_1350, this.origin.field_1351);
            }
        }
        return terminal;
    }

    public TerminalBoundingBox rotateAroundY(class_2470 rotation) {
        TerminalBoundingBox terminal = new TerminalBoundingBox(this);
        switch (rotation) {
            case field_11467: {
                terminal.min = this.min;
                terminal.max = this.max;
                terminal.origin = this.origin;
                break;
            }
            case field_11463: {
                terminal.min = new class_243(1.0 - this.max.field_1350, this.min.field_1351, this.min.field_1352);
                terminal.max = new class_243(1.0 - this.min.field_1350, this.max.field_1351, this.max.field_1352);
                terminal.origin = new class_243(1.0 - this.origin.field_1350, this.origin.field_1351, this.origin.field_1352);
                break;
            }
            case field_11464: {
                terminal.min = new class_243(1.0 - this.max.field_1352, this.min.field_1351, 1.0 - this.max.field_1350);
                terminal.max = new class_243(1.0 - this.min.field_1352, this.max.field_1351, 1.0 - this.min.field_1350);
                terminal.origin = new class_243(1.0 - this.origin.field_1352, this.origin.field_1351, 1.0 - this.origin.field_1350);
                break;
            }
            case field_11465: {
                terminal.min = new class_243(this.min.field_1350, this.min.field_1351, 1.0 - this.max.field_1352);
                terminal.max = new class_243(this.max.field_1350, this.max.field_1351, 1.0 - this.min.field_1352);
                terminal.origin = new class_243(this.origin.field_1350, this.origin.field_1351, 1.0 - this.origin.field_1352);
            }
        }
        return terminal;
    }

    public TerminalBoundingBox rotateAroundZ(class_2470 rotation) {
        TerminalBoundingBox terminal = new TerminalBoundingBox(this);
        switch (rotation) {
            case field_11467: {
                terminal.min = this.min;
                terminal.max = this.max;
                terminal.origin = this.origin;
                break;
            }
            case field_11463: {
                terminal.min = new class_243(this.min.field_1351, 1.0 - this.max.field_1352, this.min.field_1350);
                terminal.max = new class_243(this.max.field_1351, 1.0 - this.min.field_1352, this.max.field_1350);
                terminal.origin = new class_243(this.origin.field_1351, 1.0 - this.origin.field_1352, this.origin.field_1350);
                break;
            }
            case field_11464: {
                terminal.min = new class_243(1.0 - this.max.field_1352, 1.0 - this.max.field_1351, this.min.field_1350);
                terminal.max = new class_243(1.0 - this.min.field_1352, 1.0 - this.min.field_1351, this.max.field_1350);
                terminal.origin = new class_243(1.0 - this.origin.field_1352, 1.0 - this.origin.field_1351, this.origin.field_1350);
                break;
            }
            case field_11465: {
                terminal.min = new class_243(1.0 - this.max.field_1351, this.min.field_1352, this.min.field_1350);
                terminal.max = new class_243(1.0 - this.min.field_1351, this.max.field_1352, this.max.field_1350);
                terminal.origin = new class_243(1.0 - this.origin.field_1351, this.origin.field_1352, this.origin.field_1350);
            }
        }
        return terminal;
    }

    public TerminalBoundingBox rotate(class_2350.class_2351 axis, class_2470 rotation) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> this.rotateAroundX(rotation);
            case class_2350.class_2351.field_11052 -> this.rotateAroundY(rotation);
            case class_2350.class_2351.field_11051 -> this.rotateAroundZ(rotation);
        };
    }

    public TerminalBoundingBox rotate(class_2350.class_2351 axis, int angle) {
        return this.rotate(axis, TerminalBoundingBox.angleToRotation(angle));
    }

    public TerminalBoundingBox rotateAroundX(int angle) {
        return this.rotateAroundX(TerminalBoundingBox.angleToRotation(angle));
    }

    public TerminalBoundingBox rotateAroundY(int angle) {
        return this.rotateAroundY(TerminalBoundingBox.angleToRotation(angle));
    }

    public TerminalBoundingBox rotateAroundZ(int angle) {
        return this.rotateAroundZ(TerminalBoundingBox.angleToRotation(angle));
    }

    private static class_2470 angleToRotation(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return switch (angle) {
            case 0 -> class_2470.field_11467;
            case 90 -> class_2470.field_11463;
            case 180 -> class_2470.field_11464;
            case 270 -> class_2470.field_11465;
            default -> throw new IllegalArgumentException("Angle must be a multiple of 90 degrees");
        };
    }

    public TerminalBoundingBox withOrigin(class_243 origin) {
        this.origin = origin.method_1021(0.0625);
        return this;
    }

    public TerminalBoundingBox withOrigin(double x, double y, double z) {
        return this.withOrigin(new class_243(x, y, z));
    }

    public TerminalBoundingBox withColor(int rgb) {
        this.color = rgb;
        return this;
    }

    @Override
    public boolean check(class_243 position) {
        return position.field_1352 >= this.min.field_1352 && position.field_1351 >= this.min.field_1351 && position.field_1350 >= this.min.field_1350 && position.field_1352 < this.max.field_1352 && position.field_1351 < this.max.field_1351 && position.field_1350 < this.max.field_1350;
    }

    @Override
    public class_243 getOrigin() {
        return this.origin;
    }

    @Override
    public class_2561 getName() {
        return this.name;
    }

    @Override
    public class_238 getOutline() {
        return new class_238(this.min, this.max);
    }

    @Override
    public int getColor() {
        return this.color;
    }
}

