/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base.terminals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.SimpleTerminalCollectionBuilder;

public class AxisRotatedTerminalCollection {
    private final TerminalBoundingBox[][] terminals;

    private AxisRotatedTerminalCollection(TerminalBoundingBox[][] terminals) {
        this.terminals = terminals;
    }

    public TerminalBoundingBox get(class_2470 rotation, int index) {
        return this.terminals[rotation.ordinal()][index];
    }

    public static Builder builder(class_2350.class_2351 axis) {
        return new Builder(axis);
    }

    public static class Builder
    extends SimpleTerminalCollectionBuilder<Builder, AxisRotatedTerminalCollection> {
        private final List<class_2470> rotations = new ArrayList<class_2470>();
        private final class_2350.class_2351 axis;

        private Builder(class_2350.class_2351 axis) {
            this.axis = axis;
        }

        public Builder with(class_2470 rotation) {
            this.rotations.add(rotation);
            return this;
        }

        public Builder with(class_2470 ... rotations) {
            Collections.addAll(this.rotations, rotations);
            return this;
        }

        @Override
        public AxisRotatedTerminalCollection build() {
            TerminalBoundingBox[][] terminals = new TerminalBoundingBox[4][this.terminals.size()];
            for (class_2470 rotation : this.rotations) {
                for (int j = 0; j < this.terminals.size(); ++j) {
                    terminals[rotation.ordinal()][j] = ((TerminalBoundingBox)this.terminals.get(j)).rotate(this.axis, rotation);
                }
            }
            return new AxisRotatedTerminalCollection(terminals);
        }
    }
}

