/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.bell;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.bell.AlarmBellSoundInstance;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;

public class AlarmBellBlockEntity
extends ElectricBlockEntity {
    private ElectricWire wire;
    private boolean hasSoundInstance = false;

    public AlarmBellBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        if (this.getVolume() > 0.0f && !this.hasSoundInstance) {
            class_310.method_1551().method_1483().method_4873((class_1113)new AlarmBellSoundInstance(this));
            this.hasSoundInstance = true;
        } else if (this.getVolume() == 0.0f && this.hasSoundInstance) {
            this.hasSoundInstance = false;
        }
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        if (this.field_11863.field_9236) {
            this.tickAudio();
        }
    }

    public float getVolume() {
        float I = Math.abs(this.wire.current());
        if (I < 0.25f) {
            return 0.0f;
        }
        return I * 2.0f;
    }

    public float getPitch() {
        float I = Math.abs(this.wire.current());
        if (I < 0.5f) {
            return 0.75f;
        }
        return Math.min(0.5f + I * 0.5f, 1.25f);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.wire = builder.connect(this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
    }
}

