/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.contactor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.contactor.ContactorBlock;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class ContactorBlockEntity
extends ElectricBlockEntity {
    private ElectricWire coil;
    private SwitchedWire switch1;
    private SwitchedWire switch2;
    private boolean state;
    private final Set<ContactorBlockEntity> external = new HashSet<ContactorBlockEntity>();

    public ContactorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    private void checkPos(class_2338 pos, boolean newState, List<class_2338> checkQueue) {
        assert (this.field_11863 != null);
        this.field_11863.method_35230(pos, (class_2591)ModdedBlockEntities.CONTACTOR.get()).ifPresent(be -> {
            if (newState) {
                be.addExternal(this);
            } else {
                be.removeExternal(this);
            }
            checkQueue.add(pos);
        });
    }

    private void setState(boolean newState) {
        if (newState || this.external.isEmpty()) {
            this.switch1.setState(newState);
            this.switch2.setState(newState);
        }
        if (this.state != newState) {
            if (!this.field_11863.field_9236) {
                if (newState) {
                    ModdedSoundEvents.CONTACTOR_ON.playOnServer(this.field_11863, (class_2382)this.field_11867);
                } else {
                    ModdedSoundEvents.CONTACTOR_OFF.playOnServer(this.field_11863, (class_2382)this.field_11867);
                }
            }
            ArrayList<class_2338> checkQueue = new ArrayList<class_2338>();
            checkQueue.add(this.field_11867);
            HashSet<class_2338> checkedSet = new HashSet<class_2338>();
            class_2350.class_2351 axis = (class_2350.class_2351)this.method_11010().method_11654((class_2769)ContactorBlock.HORIZONTAL_AXIS);
            if (axis == class_2350.class_2351.field_11048) {
                axis = class_2350.class_2351.field_11051;
            } else if (axis == class_2350.class_2351.field_11051) {
                axis = class_2350.class_2351.field_11048;
            }
            while (!checkQueue.isEmpty()) {
                class_2338 checkPos = (class_2338)checkQueue.remove(0);
                if (!checkedSet.add(checkPos)) continue;
                class_2338 pos1 = checkPos.method_30513(axis, 1);
                this.checkPos(pos1, newState, checkQueue);
                class_2338 pos2 = checkPos.method_30513(axis, -1);
                this.checkPos(pos2, newState, checkQueue);
            }
        }
        this.state = newState;
        this.method_5431();
    }

    private void addExternal(ContactorBlockEntity be) {
        this.external.add(be);
        if (!this.state) {
            this.switch1.setState(true);
            this.switch2.setState(true);
        }
    }

    private void removeExternal(ContactorBlockEntity be) {
        this.external.remove(be);
        if (this.external.isEmpty() && !this.state) {
            this.switch1.setState(false);
            this.switch2.setState(false);
        }
    }

    public void initialize() {
        super.initialize();
        boolean state = this.state;
        this.state = false;
        this.setState(state);
    }

    public void tick() {
        this.applyPower(this.switch1);
        this.applyPower(this.switch2);
        this.applyPower(this.coil);
        super.tick();
        float I = Math.abs(this.coil.current());
        if (this.coil.isConverged()) {
            if (I > 2.0f) {
                this.setState(true);
            } else if (I < 2.0f * ModdedConfigs.server().electricity.holdingCurrentPercent.getF()) {
                this.setState(false);
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.setState(false);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (!clientPacket) {
            this.state = tag.method_10577("State");
        } else {
            this.setState(tag.method_10577("State"));
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10556("State", this.state);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(6);
        this.coil = builder.connect(this.resistance("coil"), builder.terminalNode(0), builder.terminalNode(1));
        this.switch1 = builder.connectSwitch(this.resistance("switch"), builder.terminalNode(2), builder.terminalNode(3), this.state);
        this.switch2 = builder.connectSwitch(this.resistance("switch"), builder.terminalNode(4), builder.terminalNode(5), this.state);
    }
}

