/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electricswitch;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.electricswitch.SurfaceSwitchBlock;
import org.patryk3211.powergrid.electricity.electricswitch.SwitchBlock;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.utility.Lang;

public class SwitchBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    private SwitchedWire wire;
    private float maxVoltage;
    private boolean switchState;
    private Float overvoltResistance;
    private boolean isButton;
    private int buttonTimeout = 0;
    private boolean playEffect = false;

    public SwitchBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.isButton = ((SwitchBlock)state.method_26204()).isButton;
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    private void overvoltEffect() {
        class_243 pos = this.field_11867.method_46558();
        class_2350 face = (class_2350)this.method_11010().method_11654((class_2769)SurfaceSwitchBlock.FACING);
        SparkParticleData.explodeParticles(this.field_11863, (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350, face.method_10153(), 7);
        ModdedSoundEvents.COMPONENT_EXPLODE.playAt(this.field_11863, pos, 1.0f, 1.0f, true);
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        if (this.wire.isConverged() && Math.abs(this.wire.potentialDifference()) > this.maxVoltage && this.overvoltResistance == null && !this.field_11863.field_9236) {
            this.wire.setState(true);
            this.overvoltResistance = Float.valueOf(this.field_11863.field_9229.method_43057() * 1000.0f);
            this.wire.setResistance(this.overvoltResistance.floatValue());
            this.playEffect = true;
            this.notifyUpdate();
        }
        if (this.isButton && this.buttonTimeout > 0) {
            --this.buttonTimeout;
            if (this.buttonTimeout == 0) {
                SwitchBlock block = (SwitchBlock)this.method_11010().method_26204();
                this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)SwitchBlock.OPEN, (Comparable)Boolean.valueOf(true)));
                block.useSound(this.field_11863, this.field_11867, true);
                this.setState(false);
            }
        }
    }

    public void setState(boolean state) {
        this.switchState = state;
        if (this.overvoltResistance == null) {
            this.wire.setState(state);
        }
        if (this.isButton && state) {
            this.buttonTimeout = 10;
        }
        this.notifyUpdate();
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (clientPacket) {
            this.switchState = tag.method_10577("State");
            this.wire.setState(this.switchState);
        }
        if (tag.method_10545("Overvolted")) {
            this.overvoltResistance = Float.valueOf(tag.method_10583("Overvolted"));
            this.wire.setResistance(this.overvoltResistance.floatValue());
            this.wire.setState(true);
            if (tag.method_10577("Effect")) {
                this.overvoltEffect();
            }
        }
        if (this.isButton) {
            this.buttonTimeout = tag.method_10571("Timeout");
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (clientPacket) {
            tag.method_10556("State", this.switchState);
        }
        if (this.overvoltResistance != null) {
            tag.method_10548("Overvolted", this.overvoltResistance.floatValue());
            if (this.playEffect) {
                tag.method_10556("Effect", true);
                this.playEffect = false;
            }
        }
        if (this.isButton) {
            tag.method_10567("Timeout", (byte)this.buttonTimeout);
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        class_2248 class_22482 = this.method_11010().method_26204();
        if (!(class_22482 instanceof SwitchBlock)) {
            throw new IllegalArgumentException("Blocks with SwitchBlockEntity must inherit from SwitchBlock");
        }
        SwitchBlock block = (SwitchBlock)class_22482;
        this.maxVoltage = block.getMaxVoltage();
        this.switchState = (Boolean)this.method_11010().method_11654((class_2769)SwitchBlock.OPEN) == false;
        this.wire = builder.connectSwitch(this.resistance(), builder.terminalNode(0), builder.terminalNode(1), this.switchState);
        if (this.overvoltResistance != null) {
            this.wire.setResistance(this.overvoltResistance.floatValue());
            this.wire.setState(true);
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (this.overvoltResistance == null) {
            return false;
        }
        Lang.translate("gui.damage_header", new Object[0]).forGoggles(tooltip);
        Lang.translate("gui.switch.overvolted", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        return true;
    }
}

