/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electromagnet;

import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.electromagnet.MagnetizingBehaviour;
import org.patryk3211.powergrid.electricity.electromagnet.recipe.MagnetizingRecipe;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;

public class ElectromagnetBlockEntity
extends ElectricBlockEntity
implements MagnetizingBehaviour.MagnetizingBehaviourSpecifics {
    private ElectricWire wire;
    private MagnetizingBehaviour magnetizingBehaviour;
    private static final class_1263 magnetizingInv = new class_1277(1);

    public ElectromagnetBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.magnetizingBehaviour = new MagnetizingBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.magnetizingBehaviour);
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        if (this.magnetizingBehaviour.running) {
            this.wire.setResistance(this.resistance() * 0.5f);
        } else {
            this.wire.setResistance(this.resistance());
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.wire = builder.connect(this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<class_1799> outputList, boolean simulate) {
        Optional<MagnetizingRecipe> recipe = this.getRecipe(input.stack);
        if (recipe.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        List outputs = RecipeApplier.applyRecipeOn((class_1937)this.field_11863, (class_1799)input.stack.method_46651(1), (class_1860)((class_1860)recipe.get()));
        outputList.addAll(outputs);
        return true;
    }

    @Override
    public boolean tryProcessInWorld(class_1542 itemEntity, boolean simulate) {
        class_1799 item = itemEntity.method_6983();
        Optional<MagnetizingRecipe> recipe = this.getRecipe(item);
        if (recipe.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        for (class_1799 result : RecipeApplier.applyRecipeOn((class_1937)this.field_11863, (class_1799)item.method_46651(1), (class_1860)((class_1860)recipe.get()))) {
            class_1542 created = new class_1542(this.field_11863, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), result);
            created.method_6988();
            created.method_18799(VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)this.field_11863.field_9229, (float)0.05f));
            this.field_11863.method_8649((class_1297)created);
        }
        item.method_7934(1);
        return true;
    }

    @Override
    public void onMagnetizationComplete() {
    }

    @Override
    public float getFieldStrength() {
        float field;
        float I = this.wire.current();
        if (this.isVirtual()) {
            I = (float)((double)this.wire.potentialDifference() * this.wire.conductance());
        }
        if ((field = Math.abs(I * 0.1f)) < 0.25f) {
            return 0.0f;
        }
        return field;
    }

    public Optional<MagnetizingRecipe> getRecipe(class_1799 item) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((class_1937)this.field_11863, (class_1799)item, MagnetizingRecipe.TYPE_INFO.getType(), MagnetizingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        magnetizingInv.method_5447(0, item);
        return this.field_11863.method_8433().method_8132(MagnetizingRecipe.TYPE_INFO.getType(), magnetizingInv, this.field_11863);
    }

    public MagnetizingBehaviour getMagnetizingBehaviour() {
        return this.magnetizingBehaviour;
    }
}

