/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electromagnet;

import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.electromagnet.BeltMagnetizingCallbacks;
import org.patryk3211.powergrid.electricity.electromagnet.MagnetizationParticleData;

public class MagnetizingBehaviour
extends BeltProcessingBehaviour {
    public static final int CYCLE = 240;
    public static final int COLLAPSE_TIME = 220;
    public static final int ENTITY_SCAN = 10;
    public final MagnetizingBehaviourSpecifics specifics;
    public Mode mode;
    public int prevRunningTicks;
    public int runningTicks;
    public boolean running;
    private int entityScanCooldown;
    public class_243 target;

    public <T extends SmartBlockEntity> MagnetizingBehaviour(T be) {
        super(be);
        this.specifics = (MagnetizingBehaviourSpecifics)be;
        this.whenItemEnters((s, i) -> BeltMagnetizingCallbacks.onItemReceived(s, i, this));
        this.whileItemHeld((s, i) -> BeltMagnetizingCallbacks.whenItemHeld(s, i, this));
        this.mode = Mode.WORLD;
    }

    public void start(Mode mode, class_243 target) {
        this.mode = mode;
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.target = target;
        this.blockEntity.sendData();
    }

    public void updateTarget(class_243 target) {
        this.target = target;
    }

    public void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.running = compound.method_10577("Running");
        this.mode = Mode.values()[compound.method_10550("Mode")];
        this.prevRunningTicks = this.runningTicks = compound.method_10550("Ticks");
        if (compound.method_10545("Target")) {
            class_2487 tag = compound.method_10562("Target");
            this.target = new class_243((double)tag.method_10583("X"), (double)tag.method_10583("Y"), (double)tag.method_10583("Z"));
        } else {
            this.target = null;
        }
    }

    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10556("Running", this.running);
        compound.method_10569("Mode", this.mode.ordinal());
        compound.method_10569("Ticks", this.runningTicks);
        if (this.target != null) {
            class_2487 tag = new class_2487();
            tag.method_10548("X", (float)this.target.field_1352);
            tag.method_10548("Y", (float)this.target.field_1351);
            tag.method_10548("Z", (float)this.target.field_1350);
            compound.method_10566("Target", (class_2520)tag);
        }
    }

    public void tick() {
        super.tick();
        class_1937 world = this.getWorld();
        class_2338 pos = this.getPos();
        if (!this.running || world == null) {
            if (world != null && (!world.field_9236 || this.blockEntity.isVirtual())) {
                if (this.specifics.getFieldStrength() == 0.0f) {
                    return;
                }
                if (this.entityScanCooldown > 0) {
                    --this.entityScanCooldown;
                }
                if (this.entityScanCooldown <= 0) {
                    this.entityScanCooldown = 10;
                    if (BlockEntityBehaviour.get((class_1922)world, (class_2338)pos.method_10087(2), (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE) != null) {
                        return;
                    }
                    for (class_1542 itemEntity : world.method_18467(class_1542.class, new class_238(pos.method_10074()).method_1011(0.125))) {
                        if (!itemEntity.method_5805() || !itemEntity.method_24828() || !this.specifics.tryProcessInWorld(itemEntity, true)) continue;
                        this.start(Mode.WORLD, itemEntity.method_19538().method_1031(0.0, 0.25, 0.0));
                        return;
                    }
                }
            }
            return;
        }
        if (world.field_9236 && this.runningTicks == -220) {
            this.prevRunningTicks = 220;
            return;
        }
        if (world.field_9236) {
            class_5819 r = world.field_9229;
            float particleChance = this.specifics.getFieldStrength() / 8.0f;
            if (this.runningTicks < 210 && r.method_43057() < particleChance) {
                class_243 pos0 = pos.method_46558().method_43206(class_2350.field_11033, (double)1.1f);
                class_243 pos1 = this.target != null ? this.target.method_43206(class_2350.field_11033, (double)-0.1f) : pos0.method_43206(class_2350.field_11033, 1.0);
                class_243 particlePos = VecHelper.lerp((float)r.method_43057(), (class_243)pos0, (class_243)pos1).method_1031((double)((r.method_43057() - 0.5f) * 0.2f), (double)((r.method_43057() - 0.5f) * 0.2f), (double)((r.method_43057() - 0.5f) * 0.2f));
                world.method_8406((class_2394)new MagnetizationParticleData(pos), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.0, 0.0);
            }
        }
        if (this.runningTicks == 220 && this.specifics.getFieldStrength() != 0.0f) {
            if (this.mode == Mode.WORLD) {
                this.applyInWorld();
            }
            if (!world.field_9236) {
                this.blockEntity.sendData();
            }
        }
        if ((!world.field_9236 || this.blockEntity.isVirtual()) && this.runningTicks > 240) {
            this.running = false;
            this.specifics.onMagnetizationComplete();
            this.blockEntity.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (this.prevRunningTicks < 220 && this.runningTicks >= 220) {
            this.runningTicks = 220;
            if (world.field_9236 && !this.blockEntity.isVirtual()) {
                this.runningTicks = -220;
            }
        }
        if (this.prevRunningTicks < 215 && this.runningTicks >= 215) {
            ModdedSoundEvents.MAGNETIZING.playOnServer(this.getWorld(), (class_2382)this.getPos(), 0.5f, 1.0f);
        }
        if (this.running && this.specifics.getFieldStrength() == 0.0f) {
            this.running = false;
            this.blockEntity.sendData();
        }
    }

    protected void applyInWorld() {
        class_1937 world = this.getWorld();
        class_2338 pos = this.getPos();
        class_238 bb = new class_238(pos.method_10087(1));
        if (world.field_9236) {
            return;
        }
        for (class_1297 entity : world.method_8335(null, bb)) {
            if (!(entity instanceof class_1542)) continue;
            class_1542 itemEntity = (class_1542)entity;
            if (!entity.method_5805() || !entity.method_24828()) continue;
            this.entityScanCooldown = 0;
            if (!this.specifics.tryProcessInWorld(itemEntity, false)) break;
            this.target = itemEntity.method_19538();
            this.blockEntity.sendData();
            break;
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getFieldStrength();
        if (speed == 0.0f) {
            return 0;
        }
        return class_3532.method_48781((float)class_3532.method_15363((float)(Math.abs(speed) / 32.0f), (float)0.0f, (float)1.0f), (int)1, (int)60);
    }

    public static interface MagnetizingBehaviourSpecifics {
        public boolean tryProcessOnBelt(TransportedItemStack var1, List<class_1799> var2, boolean var3);

        public boolean tryProcessInWorld(class_1542 var1, boolean var2);

        public void onMagnetizationComplete();

        public float getFieldStrength();
    }

    public static enum Mode {
        WORLD,
        BELT;

    }
}

