/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.fuse;

import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.fuse.FuseHolderBlock;
import org.patryk3211.powergrid.electricity.fuse.FuseState;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.utility.Lang;

public class FuseHolderBlockEntity
extends ElectricBlockEntity {
    private ScrollValueBehaviour setting;
    private SwitchedWire fuseWire;
    private FuseState state;

    public FuseHolderBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.state = (FuseState)((Object)state.method_11654(FuseHolderBlock.STATE));
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.setting = new ScrollValueBehaviour((class_2561)Lang.translateDirect("devices.fuse.setting", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new BoxTransform()).withFormatter(i -> Integer.toString(Math.max(1, i))).between(1, 100);
        this.setting.value = 10;
        behaviours.add((BlockEntityBehaviour)this.setting);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.fuseWire = builder.connectSwitch(this.resistance(), builder.terminalNode(0), builder.terminalNode(1), this.state == FuseState.CLOSED);
    }

    @Environment(value=EnvType.CLIENT)
    public void playEffect() {
        if (this.field_11863 == null) {
            return;
        }
        class_243 pos = this.field_11867.method_46558();
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)FuseHolderBlock.FACING);
        SparkParticleData.explodeParticles(this.field_11863, (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350, facing.method_10153(), 5);
        ModdedSoundEvents.FUSE_POPS.playAt(this.field_11863, pos, 1.0f, 1.0f, false);
    }

    public void tick() {
        super.tick();
        if (this.fuseWire.getState() && this.fuseWire.isConverged() && Math.abs(this.fuseWire.current()) > (float)this.setting.value) {
            this.setState(FuseState.BLOWN);
            if (this.field_11863.field_9236) {
                this.playEffect();
            }
        }
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        FuseState prevState = this.state;
        this.state = FuseState.values()[tag.method_10550("State")];
        if (clientPacket && this.state == FuseState.BLOWN && prevState == FuseState.CLOSED) {
            this.playEffect();
        }
        this.fuseWire.setState(this.state == FuseState.CLOSED);
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10569("State", this.state.ordinal());
    }

    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        tag.method_10569("State", this.state.ordinal());
    }

    public ItemRequirement getRequiredItems(class_2680 state) {
        if (this.state == FuseState.CLOSED) {
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, ModdedItems.IRON_WIRE.asStack());
        }
        return ItemRequirement.NONE;
    }

    public boolean resetFuse() {
        if (this.state == FuseState.OPEN || this.state == FuseState.BLOWN) {
            if (!this.field_11863.field_9236) {
                this.setState(FuseState.CLOSED);
                ModdedSoundEvents.FUSE_INSTALL.playOnServer(this.field_11863, (class_2382)this.field_11867);
            }
            return true;
        }
        return false;
    }

    public boolean removeBlown() {
        if (this.state == FuseState.BLOWN) {
            this.setState(FuseState.OPEN);
            return true;
        }
        return false;
    }

    public void setState(FuseState state) {
        if (this.state != state) {
            this.state = state;
            if (this.field_11863 != null) {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(FuseHolderBlock.STATE, (Comparable)((Object)state)));
                if (!this.field_11863.field_9236) {
                    this.notifyUpdate();
                }
            }
            this.fuseWire.setState(state == FuseState.CLOSED);
        }
    }

    public static class BoxTransform
    extends CenteredSideValueBoxTransform {
        public BoxTransform() {
            super((state, dir) -> dir.method_10153() == state.method_11654((class_2769)FuseHolderBlock.FACING));
        }

        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)9.0);
        }
    }
}

