/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.heater;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.config.ThermalValues;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class HeaterBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    private ElectricWire wire;
    private State state = State.COLD;

    public HeaterBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        if (this.thermalBehaviour == null) {
            PowerGrid.LOGGER.warn("Heating coil should always have a thermal behaviour");
            return;
        }
        float temperature = this.thermalBehaviour.getTemperature();
        if (temperature < 200.0f) {
            this.updateState(State.COLD);
        } else if (temperature < 400.0f) {
            this.updateState(State.SMOKING);
        } else {
            this.updateState(State.BLASTING);
        }
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        class_2248 block = this.method_11010().method_26204();
        return ThermalBehaviour.always(this, ThermalValues.getMass(block), ThermalValues.getPower(block) / 600.0f, 600.0f);
    }

    private void updateState(State state) {
        assert (this.field_11863 != null);
        if (this.state != state) {
            this.state = state;
            this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
        }
    }

    public State getState() {
        return this.state;
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.wire = builder.connect(this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
    }

    protected class_124 temperatureColor(float value) {
        if (value < 200.0f) {
            return class_124.field_1063;
        }
        if (value < 400.0f) {
            return class_124.field_1060;
        }
        if (value < 550.0f) {
            return class_124.field_1054;
        }
        return class_124.field_1061;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        Lang.translate("gui.heater.info_header", new Object[0]).forGoggles(tooltip);
        Lang.builder().translate("gui.heater.title", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        float temperature = this.thermalBehaviour.getTemperature();
        temperature = (float)Math.round(temperature * 100.0f) / 100.0f;
        String temperatureText = String.format("%.2f", Float.valueOf(temperature));
        Lang.builder().text(temperatureText).add(class_2561.method_30163((String)" ")).add(Unit.TEMPERATURE.get()).style(this.temperatureColor(temperature)).forGoggles(tooltip, 1);
        return true;
    }

    public static enum State {
        COLD,
        SMOKING,
        BLASTING;

    }
}

