/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.light.bulb;

import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedTags;
import org.patryk3211.powergrid.electricity.light.bulb.LightBulb;
import org.patryk3211.powergrid.electricity.light.bulb.LightBulbState;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlockEntity;

public class GrowthLamp
extends LightBulb {
    public GrowthLamp(class_1792.class_1793 settings) {
        super(settings);
    }

    @Override
    public LightBulbState createState(LightFixtureBlockEntity fixture) {
        return new State(this, fixture, this.modelSupplier);
    }

    public static class State
    extends LightBulb.SimpleState {
        public <T extends class_1792> State(T bulb, LightFixtureBlockEntity fixture, Supplier<Function<LightBulb.State, PartialModel>> modelProviderSupplier) {
            super(bulb, fixture, modelProviderSupplier);
        }

        @Override
        public void tick() {
            int z;
            int y;
            int x;
            class_2338 pos;
            class_2680 state;
            super.tick();
            if (this.burned) {
                return;
            }
            class_1937 world = this.fixture.method_10997();
            int power = this.getPowerLevel();
            if (world.field_9236 || power == 0) {
                return;
            }
            class_2338 origin = this.fixture.method_11016();
            class_2350 facing = ((class_2350)this.fixture.method_11010().method_11654((class_2769)LightFixtureBlock.FACING)).method_10153();
            Integer radius = (Integer)ModdedConfigs.server().electricity.growthLampRadius.get();
            int xMin = -radius.intValue();
            int xMax = radius;
            int yMin = -radius.intValue();
            int yMax = radius;
            int zMin = -radius.intValue();
            int zMax = radius;
            switch (facing) {
                case field_11034: {
                    xMin = 0;
                    break;
                }
                case field_11039: {
                    xMax = 0;
                    break;
                }
                case field_11036: {
                    yMin = 0;
                    break;
                }
                case field_11033: {
                    yMax = 0;
                    break;
                }
                case field_11035: {
                    zMin = 0;
                    break;
                }
                case field_11043: {
                    zMax = 0;
                }
            }
            class_3218 serverWorld = (class_3218)world;
            class_5819 random = serverWorld.field_9229;
            int chanceValue = (Integer)ModdedConfigs.server().electricity.growthLampChance.get() / power;
            if ((chanceValue <= 0 || random.method_43048(chanceValue) == 0) && (state = serverWorld.method_8320(pos = origin.method_10069(x = random.method_39332(xMin, xMax), y = random.method_39332(yMin, yMax), z = random.method_39332(zMin, zMax)))).method_26164(ModdedTags.Block.AFFECTED_BY_LAMP.tag)) {
                state.method_26199(serverWorld, pos, random);
            }
        }
    }
}

