/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.light.bulb;

import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.light.bulb.ILightBulb;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlockEntity;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public abstract class LightBulbState {
    protected final class_1792 item;
    protected final ILightBulb bulb;
    protected final LightFixtureBlockEntity fixture;
    protected final float thermalMass;
    protected final float dissipationFactor;
    protected final float overheatTemperature;
    protected float temperature;
    protected boolean burned;
    private int overheatTicks;
    private boolean playEffect;

    public <T extends class_1792> LightBulbState(T bulb, LightFixtureBlockEntity fixture) {
        this.item = bulb;
        this.bulb = (ILightBulb)bulb;
        this.fixture = fixture;
        ILightBulb.Properties properties = ((ILightBulb)bulb).thermalProperties();
        this.thermalMass = properties.thermalMass();
        this.dissipationFactor = properties.dissipationFactor();
        this.overheatTemperature = properties.overheatTemperature();
        this.burned = false;
    }

    protected void applyPower(float power) {
        if (this.burned) {
            return;
        }
        float energy = power / 20.0f;
        this.temperature += energy / this.thermalMass;
        if (energy < 0.0f && this.temperature < 22.0f) {
            this.temperature = 22.0f;
        }
    }

    protected void updatePowerLevel(int newLevel) {
        class_1937 world = this.fixture.method_10997();
        class_2680 state = this.fixture.method_11010();
        if (newLevel != (Integer)state.method_11654((class_2769)LightFixtureBlock.POWER)) {
            world.method_8501(this.fixture.method_11016(), (class_2680)state.method_11657((class_2769)LightFixtureBlock.POWER, (Comparable)Integer.valueOf(newLevel)));
        }
    }

    public int getPowerLevel() {
        return (Integer)this.fixture.method_11010().method_11654((class_2769)LightFixtureBlock.POWER);
    }

    private void burnEffect() {
        class_1937 world = this.fixture.method_10997();
        if (world.field_9236) {
            class_243 pos = this.fixture.method_11016().method_46558();
            world.method_8406((class_2394)class_2398.field_17909, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
        }
    }

    public void tick() {
        if (this.burned) {
            return;
        }
        SwitchedWire filament = this.fixture.getFilament();
        float dissipatedPower = this.dissipationFactor * (this.temperature - 22.0f);
        if (filament.isConverged()) {
            this.applyPower(filament.power() - dissipatedPower);
        }
        if (!Float.isFinite(this.temperature)) {
            this.temperature = 22.0f;
        }
        filament.setResistance(this.bulb.resistanceFunction(this.temperature));
        class_1937 world = this.fixture.method_10997();
        if (!world.field_9236) {
            if (this.isOverheated() && this.overheatTicks++ >= 4) {
                this.burned = true;
                this.playEffect = true;
                filament.setState(false);
                this.updatePowerLevel(0);
                this.fixture.notifyUpdate();
                return;
            }
            if (!this.isOverheated()) {
                this.overheatTicks = 0;
            }
            int powerLevel = 0;
            if (this.temperature > 1400.0f) {
                powerLevel = 2;
            } else if (this.temperature > 1200.0f) {
                powerLevel = 1;
            }
            this.updatePowerLevel(powerLevel);
        }
    }

    public boolean isOverheated() {
        return this.temperature >= this.overheatTemperature;
    }

    public boolean isBurned() {
        return this.burned;
    }

    public float resistance() {
        return this.bulb.resistanceFunction(this.temperature);
    }

    public class_1799 toStack() {
        return new class_1799((class_1935)this.item);
    }

    public boolean isOf(class_1792 item) {
        return this.item == item;
    }

    @Environment(value=EnvType.CLIENT)
    public abstract PartialModel getModel();

    @NotNull
    @Environment(value=EnvType.CLIENT)
    public abstract PartialModel getLightModel();

    public float getAlpha() {
        float x = class_3532.method_15363((float)((this.temperature - 600.0f) / 800.0f), (float)0.0f, (float)1.0f);
        return x * x;
    }

    public void write(class_2487 nbt) {
        nbt.method_10582("Bulb", class_7923.field_41178.method_10221((Object)this.item).toString());
        nbt.method_10548("Temperature", this.temperature);
        if (this.burned) {
            nbt.method_10556("Burned", true);
        }
        if (this.playEffect) {
            nbt.method_10556("Effect", true);
            this.playEffect = false;
        }
    }

    public void read(class_2487 nbt) {
        class_1792 bulbItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(nbt.method_10558("Bulb")));
        if (bulbItem != this.item) {
            PowerGrid.LOGGER.error("Bulb item validation failed");
            return;
        }
        this.temperature = nbt.method_10583("Temperature");
        this.burned = nbt.method_10577("Burned");
        this.fixture.getFilament().setState(!this.burned);
        if (nbt.method_10577("Effect")) {
            this.burnEffect();
        }
    }

    public static class_1792 getBulbItem(class_2487 nbt) {
        if (!nbt.method_10545("Bulb")) {
            return null;
        }
        class_1792 bulbItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(nbt.method_10558("Bulb")));
        if (!(bulbItem instanceof ILightBulb)) {
            PowerGrid.LOGGER.error("Tried to use a non light bulb item for light bulb state");
            return null;
        }
        return bulbItem;
    }

    public class_1792 getItem() {
        return this.item;
    }
}

