/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.particles;

import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.render.DefaultSuperRenderTypeBuffer;
import net.minecraft.class_243;
import net.minecraft.class_3545;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.patryk3211.powergrid.collections.ModdedRenderLayers;
import org.patryk3211.powergrid.electricity.particles.ZapParticleData;

public class ZapParticle
extends class_703 {
    private final Vector3f delta;
    private final Vector3f cross1;
    private final Vector3f cross2;
    private final boolean anchorEnd;
    private final int segmentCount;
    private final List<class_3545<Vector3f, Vector3f>> segments = new ArrayList<class_3545<Vector3f, Vector3f>>();

    public ZapParticle(ZapParticleData data, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        Vector3f end = data.getEnd();
        this.anchorEnd = data.isAnchored();
        this.field_3847 = data.getLife();
        this.segmentCount = data.getSegmentCount();
        this.field_3859 = 0.5f;
        this.delta = new Vector3f((float)((double)end.x - this.field_3874), (float)((double)end.y - this.field_3854), (float)((double)end.z - this.field_3871));
        Vector3f vec = new Vector3f(1.0f - this.delta.x, 1.0f - this.delta.y, 1.0f - this.delta.z);
        this.cross1 = new Vector3f();
        vec.cross((Vector3fc)this.delta, this.cross1).normalize().mul(0.02f);
        this.cross2 = new Vector3f();
        this.cross1.cross((Vector3fc)this.delta, this.cross2).normalize().mul(0.02f);
        this.makeNewSegments();
    }

    public void addSegment(Vector3f pos1, Vector3f pos2) {
        this.segments.add((class_3545<Vector3f, Vector3f>)new class_3545((Object)pos1, (Object)pos2));
    }

    public void addSegment(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.segments.add((class_3545<Vector3f, Vector3f>)new class_3545((Object)new Vector3f(x1, y1, z1), (Object)new Vector3f(x2, y2, z2)));
    }

    public void makeNewSegments() {
        this.segments.clear();
        Vector3f pos = new Vector3f((float)this.field_3874, (float)this.field_3854, (float)this.field_3871);
        Vector3f straightPos = new Vector3f((Vector3fc)pos);
        int segmentCount = this.segmentCount == -1 ? Math.max((int)(this.delta.length() / 0.5f), 3) : this.segmentCount;
        Vector3f segmentVector = new Vector3f((Vector3fc)this.delta).mul(1.0f / (float)segmentCount);
        float segmentLength = this.delta.length() / (float)segmentCount;
        float totalLength = this.delta.length();
        for (int i = 0; i < segmentCount; ++i) {
            Vector3f straightEndPos = new Vector3f((Vector3fc)segmentVector).add((Vector3fc)straightPos);
            Vector3f endPos = new Vector3f((Vector3fc)segmentVector).add((Vector3fc)pos);
            endPos.add((Vector3fc)new Vector3f((Vector3fc)this.cross1).mul(this.field_3840.method_43057() - 0.5f).mul(totalLength * 50.0f)).add((Vector3fc)new Vector3f((Vector3fc)this.cross2).mul(this.field_3840.method_43057() - 0.5f).mul(totalLength * 50.0f));
            int middle = segmentCount / 2;
            float factor = this.anchorEnd ? 1.0f - (float)Math.abs(middle - i - 1) / (float)(middle + 1) : (float)i / (float)middle;
            float invFactor = 1.0f - factor;
            endPos.mul(factor).add(straightEndPos.x * invFactor, straightEndPos.y * invFactor, straightEndPos.z * invFactor);
            this.addSegment(pos, endPos);
            if (i != 0 && this.field_3840.method_43057() < 0.2f) {
                float x = (this.field_3840.method_43057() - 0.5f) * segmentLength * 2.0f;
                float y = (this.field_3840.method_43057() - 0.5f) * segmentLength * 2.0f;
                float z = (this.field_3840.method_43057() - 0.5f) * segmentLength * 2.0f;
                this.addSegment(pos.x, pos.y, pos.z, pos.x + x, pos.y + y, pos.z + z);
                if (this.field_3840.method_43057() < 0.2f) {
                    float x2 = x + (this.field_3840.method_43057() - 0.5f);
                    float y2 = y + (this.field_3840.method_43057() - 0.5f);
                    float z2 = z + (this.field_3840.method_43057() - 0.5f);
                    this.addSegment(pos.x + x, pos.y + y, pos.z + z, pos.x + x2, pos.y + y2, pos.z + z2);
                }
            }
            straightPos = straightEndPos;
            pos = endPos;
        }
    }

    public void method_3070() {
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        } else {
            this.makeNewSegments();
        }
    }

    public void renderSegment(class_4588 buffer, float x1, float y1, float z1, float x2, float y2, float z2, Vector3f cross1, Vector3f cross2) {
        buffer.method_22912((double)(x1 + cross1.x), (double)(y1 + cross1.y), (double)(z1 + cross1.z)).method_1344();
        buffer.method_22912((double)(x1 - cross1.x), (double)(y1 - cross1.y), (double)(z1 - cross1.z)).method_1344();
        buffer.method_22912((double)(x2 - cross1.x), (double)(y2 - cross1.y), (double)(z2 - cross1.z)).method_1344();
        buffer.method_22912((double)(x2 + cross1.x), (double)(y2 + cross1.y), (double)(z2 + cross1.z)).method_1344();
        buffer.method_22912((double)(x1 + cross2.x), (double)(y1 + cross2.y), (double)(z1 + cross2.z)).method_1344();
        buffer.method_22912((double)(x1 - cross2.x), (double)(y1 - cross2.y), (double)(z1 - cross2.z)).method_1344();
        buffer.method_22912((double)(x2 - cross2.x), (double)(y2 - cross2.y), (double)(z2 - cross2.z)).method_1344();
        buffer.method_22912((double)(x2 + cross2.x), (double)(y2 + cross2.y), (double)(z2 + cross2.z)).method_1344();
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        DefaultSuperRenderTypeBuffer bufferProvider = DefaultSuperRenderTypeBuffer.getInstance();
        class_4588 buffer = bufferProvider.getBuffer(ModdedRenderLayers.getColor());
        class_243 camPos = camera.method_19326();
        buffer.method_22901((int)(this.field_3861 * 255.0f), (int)(this.field_3842 * 255.0f), (int)(this.field_3859 * 255.0f), (int)(this.field_3841 * 255.0f));
        for (class_3545<Vector3f, Vector3f> segment : this.segments) {
            Vector3f pos1 = new Vector3f((Vector3fc)segment.method_15442()).sub((Vector3fc)camPos.method_46409());
            Vector3f pos2 = new Vector3f((Vector3fc)segment.method_15441()).sub((Vector3fc)camPos.method_46409());
            this.renderSegment(buffer, pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z, this.cross1, this.cross2);
        }
        buffer.method_35666();
        bufferProvider.draw();
    }

    public class_3999 method_18122() {
        return class_3999.field_17831;
    }
}

