/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.resistor;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.NumberFormats;

public class ResistorValueBehaviour
extends ScrollValueBehaviour {
    private final int minOffset;

    public ResistorValueBehaviour(class_2561 label, SmartBlockEntity be, ValueBoxTransform slot, int minOffset, int max) {
        super(label, be, slot);
        this.minOffset = minOffset;
        this.between(0, max);
        this.withFormatter(i -> NumberFormats.formatPrecise(ResistorValueBehaviour.exponentialValue(minOffset, i)));
    }

    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        ImmutableList rows = ImmutableList.of((Object)Lang.translateDirect("generic.unit.ohm", new Object[0]));
        ValueSettingsFormatter formatter = new ValueSettingsFormatter(this::formatSettings);
        return new ValueSettingsBoard(this.label, this.max, 9, (List)rows, formatter);
    }

    public void setValueSettings(class_1657 player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
        int value = Math.max(0, valueSetting.value());
        if (!valueSetting.equals((Object)this.getValueSettings())) {
            this.playFeedbackSound((BlockEntityBehaviour)this);
        }
        this.setValue(value);
    }

    public ScrollValueBehaviour withResistanceCallback(Consumer<Float> resistanceCallback) {
        return super.withCallback(i -> resistanceCallback.accept(Float.valueOf(ResistorValueBehaviour.exponentialValue(this.minOffset, i))));
    }

    public static float exponentialValue(int min, int i) {
        int number = i % 9 + 1;
        double mult = Math.pow(10.0, i / 9 - min);
        return (float)((double)number * mult);
    }

    public class_5250 formatSettings(ValueSettingsBehaviour.ValueSettings settings) {
        return Lang.text(NumberFormats.formatPrecise(ResistorValueBehaviour.exponentialValue(this.minOffset, settings.value()))).component();
    }

    public float getResistance() {
        return ResistorValueBehaviour.exponentialValue(this.minOffset, this.value);
    }
}

