/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.VoltageSourceCoupling;
import org.patryk3211.powergrid.electricity.sim.solver.IResidualAdder;
import org.patryk3211.powergrid.electricity.sim.special.IRotor;

public class GeneratorCoupling
extends VoltageSourceCoupling {
    private static final float DT = 0.05f;
    private final IRotor rotor;
    private float field;
    private float baseResistance;
    private float backEmf;

    public GeneratorCoupling(IElectricNode positive, @Nullable IElectricNode negative, Number resistance, IRotor rotor) {
        super(positive, negative, resistance);
        this.rotor = rotor;
        this.baseResistance = resistance.floatValue();
    }

    public void setField(float field) {
        this.field = field;
        this.backEmf = field * field * 0.05f / this.rotor.getInertia();
        super.setResistance(this.baseResistance + this.backEmf);
    }

    @Override
    public void addStaticResidual(IResidualAdder residual) {
        super.addStaticResidual(residual);
        float v = -this.backEmf * this.getCurrent();
        if (Math.signum(v) == Math.signum(this.getVoltage())) {
            residual.add(this.index, v);
        }
    }

    @Override
    public void setResistance(float resistance) {
        this.baseResistance = resistance;
        super.setResistance(resistance + this.backEmf);
    }

    public void tick(float newField) {
        if (this.isConverged()) {
            this.rotor.applyTickForce(this.field * this.getCurrent());
        }
        this.setField(newField);
        this.setVoltage(this.field * this.rotor.getAngularVelocityRadians());
    }
}

